;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright (C) 1989, 1990, 1991, 1992 Aubrey Jaffer.
;;; See the file `COPYING' for terms applying to this program.

;;;; Here are the templates for 2 dimensional output

(define tps:2d
  '(
    (TEMPLATE:DEFAULT 140 #d0140 "(" #d1010 #(REST ", " #d2010) ")")
    (TEMPLATE:BUNCH 140 "[" #d0010 #(REST ", " BREAK #d1010) "]")
    (TEMPLATE:MATRIX 140 (#\[) #d0010 #(REST "  " #d1010) (#\]))
    (TEMPLATE:PARENTHESIS 200 "(" #d1010 ")")
    (- 100 #d1100 " - " BREAK #d2101 #(REST " - " BREAK #d3101))
    (NEGATE 100 "- " #d1100)
    (+ 100 #d1100 #(REST " + " BREAK #d2101))
    (* 120 #d1120 #(REST " " #d2121))
    (/ 120 #d1120 "/" #d2121)
    (OVER 120 ((-1 #d1040)
	       (0 #\-)
	       (1 #d2040)))
    (^ 140 #d1140 ((-1 #d2100)))
    (= 80 #d1080 " = " BREAK #d2080 #(REST " = " BREAK #d3080))
    (DIFFERENTIAL 170 #d1170 "'")
    (SUCHTHAT 40 "{" #d1190 " | " #d2040 "}")
    (DEFINE 200 #d1120 ": " ((0 #d2010)))
    (RAPPLY 200 #d1200 ((1 #d2030 #(REST "," #d3010))))
    (ABS 200 (#\|) #d1010 (#\|))
    (BOX 200 ((-1 #\")
	      (0 (#\") #d1010 (#\"))
	      (1 #\")))
    (FACTORIAL 160 #d1160 "!")
    (INTEGRATE 120 ((-3 #(OPTIONAL #d4090))
		    (-2 "/ ")
		    (-1 "! ")
		    (0 "! ")
		    (1 "! ")
		    (2 "/ ")
		    (3 #(OPTIONAL #d3090)))
	       #d1090 "d" #d2120)
    (LIMIT 90 ((0 "limit ")
	       (1 #d2090 "->" #d3090))
	   #d1090)
    (SUM 90 ((-3 #(OPTIONAL #d4090))
	     (-2 "====")
	     (-1 "\\   ")
	     (0 " >  ")
	     (1 "/   ")
	     (2 "====")
	     (3 #(OPTIONAL #d2090 #(OPTIONAL" = " #d3090))))
	 #d1090)
    (PROD 90 ((-3 " " #(OPTIONAL #d4090))
	      (-2 "/===/")
	      (-1 " ! ! ")
	      (0  " ! ! ")
	      (1  " ! ! ")
	      (2 #(OPTIONAL #d2090 #(OPTIONAL" = " #d3090))))
	  #d1090)
    (AT 90 #d1090
	((-2 "!")
	 (-1 "!")
	 (0 "!")
	 (1 "!")
	 (2 "!"))
	((2 #d2010 #(REST ", " #d3010))))
    (QED 100 "qed")
    (% 200 "%")
    (NCMULT 110 #d1109 " . " #d2109)
    (^^ 210 #d1210 "^^" #d2210)
    ))

(define tps:c
  '(
    (TEMPLATE:DEFAULT 140 #d0140 "(" #d1010 #(REST ", " #d2010) ")")
    (TEMPLATE:BUNCH 140 "{" #d0010 #(REST ", " #d1010) "}")
    (TEMPLATE:PARENTHESIS 200 "(" #d1010 ")")
    (= 80 #d1080 " == " BREAK #d2080 #(REST "==" BREAK #d3080))
    (- 100 #d1100 " - " BREAK #d2101 #(REST " - " BREAK #d3101))
    (+ 100 #d1100 #(REST " + " BREAK #d2101))
    (* 120 #d1120 #(REST " * " #d2121))
    (NEGATE 90 "- " #d1090)
    (/ 120 #d1120 "/" #d2121)
    (OVER 120 #d1120 "/" #d2121)
    (^ 140 "pow(" #d1140 ", " #d2100 ")")
    (RAPPLY 200 #d1200 "[" #d2030 #(REST "," #d3010) "]")
    (BOX 200 ((-1 #\")
	      (0 (#\") #d1010 (#\"))
	      (1 #\")))
    (DEFINE 200 #d1120 " = " #d2010)
    (SET 20 "set " #d1120 " " #d2010)
    (SHOW 20 "show " #d1120)
    ))

(define tps:std
  '(
    (TEMPLATE:DEFAULT 140 #d0140 "(" #d1010 #(REST ", " #d2010) ")")
    (TEMPLATE:BUNCH 140 "[" #d0010 #(REST ", " #d1010) "]")
    (TEMPLATE:PARENTHESIS 200 "(" #d1010 ")")
    (= 80 #d1080 " = " BREAK #d2080 #(REST " = " BREAK #d3080))
    (- 100 #d1100 " - " BREAK #d2101 #(REST " - " BREAK #d3101))
    (+ 100 #d1100 #(REST " + " BREAK #d2101))
    (* 120 #d1120 #(REST " * " #d2121))
    (NEGATE 90 "- " #d1090)
    (/ 120 #d1120 "/" #d2121)
    (OVER 120 #d1120 "/" #d2121)
    (^ 140 #d1140 "^" #d2140)
    (DIFFERENTIAL 170 #d1170 "'")
    (SUCHTHAT 40 "{" #d1190 " | " #d2040 "}")
    (RAPPLY 200 #d1200 "[" #d2030 #(REST "," #d3010) "]")
    (BOX 200 ((-1 #\")
	      (0 (#\") #d1010 (#\"))
	      (1 #\")))
    (DEFINE 200 #d1120 ": " #d2010)
    (SET 20 "set " #d1120 " " #d2010)
    (SHOW 20 "show " #d1120)
    (FACTORIAL 160 #d1160 "!")
    (QED 100 "qed")
    (% 200 "%")
    (NCMULT 110 #d1109 " . " #d2109)
    (^^ 210 #d1210 "^^" #d2210)
    ))

(define tps:tex
  '(
    (TEMPLATE:TOP 0 "$" #d1000 "$")
    (TEMPLATE:DEFAULT 140 #d0140 "\\left(" #d1010
		      #(REST ", " #d2010) "\\right)")
    (TEMPLATE:BUNCH 140 "\\left[" #d0010 #(REST ", " BREAK #d1010) "\\right]")
    (TEMPLATE:PARENTHESIS 200 "\\left(" #d1010 "\\right)")
    (= 80 #d1080 " = " BREAK #d2080 #(REST " = " BREAK #d3080))
    (- 100 #d1100 " - " BREAK #d2101 #(REST " - " BREAK #d3101))
    (+ 100 #d1100 #(REST " + " BREAK #d2101))
    (* 120 #d1120 #(REST " " #d2121))
    (NEGATE 90 "- " #d1100)
    (/ 120 #d1120 "/{" BREAK #d2121 "}")
    (OVER 120 "{" #d1040 "}\\over{" BREAK #d2041 "}")
    (^ 140 #d1140 "^{" #d2100 "}")
    (DIFFERENTIAL 170 "{" #d1170 "}'")
    (SUCHTHAT 40 "\\left\\{ " #d1190 " | " BREAK #d2040 "\\right\\}")
    (RAPPLY 200 #d1200 "\\left[" #d2030 #(REST "," BREAK #d3010) "\\right]")
    (ABS 200 "\\left|" #d1010 "\\right|")
;;;    (BOX 200 ((-1 #\")
;;;	      (0 (#\") #d1010 (#\"))
;;;	      (1 #\")))
    (DEFINE 200 #d1120 ": " #d2010)
    (SET 20 "set " #d1120 " " #d2010)
    (SHOW 20 "show " #d1120)
    (FACTORIAL 160 #d1160 "!")
    (QED 100 "qed")
    (% 200 "%")
    ))

(defgrammar 'standard
  (make-grammar
   'standard				;name
   (lambda (grm)			;reader
     (set! *lex-rules* (grammar-lex-tab grm))
     (set! *syn-rules* (grammar-read-tab grm))
     (set! cgol:arg-separator #\,)
     (cgol:top-parse #\;))
   (make-hash-table 51)			;lex-tab
   (make-hash-table 51)			;read-tab
   inprint				;writer
   tps:std))				;write-tab

(defgrammar 'disp2d
  (make-grammar
   'disp2d					;name
   (lambda (grm)			;reader
     (set! *lex-rules* (grammar-lex-tab grm))
     (set! *syn-rules* (grammar-read-tab grm))
     (set! cgol:arg-separator #\,)
     (cgol:top-parse #\;))
   (grammar-lex-tab (get-grammar 'standard)) ;lex-tab
   (grammar-read-tab (get-grammar 'standard)) ;read-tab
   inprint				;writer
   tps:2d))				;write-tab

(defgrammar 'tex
  (make-grammar
   'tex					;name
   (lambda (grm)			;reader
     (set! *lex-rules* (grammar-lex-tab grm))
     (set! *syn-rules* (grammar-read-tab grm))
     (set! cgol:arg-separator #\,)
     (cgol:top-parse #\;))
   (make-hash-table 51)			;lex-tab
   (make-hash-table 51)			;read-tab
   inprint				;writer
   tps:tex))				;write-tab

;;;;The parse tables.

;(require "parse.scm")
;(set! *lex-defs* (make-hash-table 51))
;(set! *syn-defs* (make-hash-table 37))
(set! *lex-defs* (grammar-lex-tab (get-grammar 'standard)))
(set! *syn-defs* (grammar-read-tab (get-grammar 'standard)))

;;;Syntax definitions for STANDARD GRAMMAR
(lex:def-class 70 '(#\^) #f)
(lex:def-class 49 '(#\*) #f)
(lex:def-class 50 '(#\/) #f)
(lex:def-class 51 '(#\+ #\-) #f)
(lex:def-class 20 '(#\|) #f)
(lex:def-class 30 '(#\< #\> #\= #\: #\~) #f)
(lex:def-class 40 '(#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
	       (lambda (l) (string->number (list->string l))))
(lex:def-class 41
	    '(#\A #\B #\C #\D #\E #\F #\G #\H #\I #\J #\K #\L #\M
	      #\N #\O #\P #\Q #\R #\S #\T #\U #\V #\W #\X #\Y #\Z
	      #\a #\b #\c #\d #\e #\f #\g #\h #\i #\j #\k #\l #\m
	      #\n #\o #\p #\q #\r #\s #\t #\u #\v #\w #\x #\y #\z
	      #\@ #\_ #\% #\?)
	    #f)
(lex:def-class (lambda (chr) (or (eqv? #\" chr) (eof-object? chr)))
	    '(#\")
	    (lambda (l)
	      (lex:read-char) (string->symbol (list->string (cdr l)))))
;;; TeX style comment.  Better to do using CGOL:COMMENTFIX.
;(lex:def-class (lambda (chr) (or (eqv? #\$ chr) (eof-object? chr)))
;	       '(#\$)
;	       (lambda (l) (lex:read-char) (lex)))
;;; Ignore leading whitespace.
(lex:def-class 0 (list slib:tab slib:form-feed #\  #\newline) #f)

;;; Delimiters and Separators
(cgol:separator #\, 10)
(cgol:delim #\; 0)
(cgol:delim (integer->char 0) 0)		;EOF
;(cgol:postfix #\$ (lambda (x) (write x)) 0)

;;;prefix operators
(cgol:prefix '+ #f 100)
(cgol:prefix '- 'negate 100)
(cgol:prefix '+/- 'u+/- 100)
(cgol:prefix '-/+ 'u-/+ 100)
(cgol:prefix '(NOT ~) 'impl_not 70)
(cgol:prefix ":" 'SetTemplate! 20)

;;;postfix operators
(cgol:postfix #\! 'factorial 160)
(cgol:postfix #\' 'Differential 170)

;;;infix operators
;(cgol:infix 'X 'crossproduct 111 110)
(cgol:infix #\. 'ncmult 110 109)
(cgol:infix '(^ **) '^ 140 139)
(cgol:infix '^^ '^^ 210 210)
(cgol:infix '(":=" ":") 'define 180 20)
(cgol:infix '= '= 80 80)
(cgol:infix '(~= <>) 'make-not-equal 80 80)
(cgol:infix 'mod 'mod 70 70)

;(cgol:infix "" '* 120 120)		;null operator

;;;nary operators
(cgol:nary '* '* 120)
(cgol:nary '+ '+ 100)
(cgol:nary '- '- 100)
(cgol:nary '+/- 'b+/- 100)
(cgol:nary '-/+ 'b-/+ 100)
(cgol:nary '/ '/ 120)
(cgol:nary '(AND #\&) '& 60)
(cgol:nary 'OR 'or 50)

;;;special operators
(cgol:inmatchfix #\( #f #\) 200)
(cgol:inmatchfix #\[ 'rapply #\] 200)

;;;matchfix operators
(cgol:matchfix #\( #f #\))
(cgol:matchfix #\[ vector #\])
(cgol:matchfix #\{ 'or #\})
(cgol:matchfix #\\ 'lambda #\;)

(cgol:infix "|" 'suchthat 190 40)
(cgol:prefix 'load 'load 50)
(cgol:nofix '% '%)
(cgol:nofix '(QED bye exit) 'qed)

(cgol:commentfix
 '/* (lambda ()
       (define echoing (not (eq? (get-grammar 'null) *echo-grammar*)))
       (do ((c (lex:read-char) (lex:read-char)))
	   ((or (eof-object? c)
		(and (char=? #\* c)
		     (char=? #\/ (lex:peek-char))))
	    (lex:read-char))
	 (if echoing (display c)))))

;;;rest operator reads expressions up to next delimiter.
(cgol:rest 'set 'set 10)
(cgol:rest 'show 'show 10)

(set! *input-grammar* (get-grammar 'standard))
(set! *output-grammar* (get-grammar 'disp2d))

;(set! *lex-defs* (grammar-lex-tab (get-grammar 'TeX)))
;(set! *syn-defs* (grammar-read-tab (get-grammar 'TeX)))

;;;Syntax definitions for TEX GRAMMAR
;(lex:def-class 30 '(#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
;	       (lambda (l) (string->number (list->string l))))
;(lex:def-class (let ((seen1 #f))
;		 (lambda (chr)
;		   (cond (seen1 (not (or (char-whitespace? chr)
;					 (char-numeric? chr))))
;			 (else (set! seen1 #t) #f))))
;	       '(#\\)
;	       #f)
;;; TeX style comment.  Better to do using CGOL:COMMENTFIX.
;(lex:def-class (lambda (chr) (or (eqv? #\$ chr) (eof-object? chr)))
;	       '(#\$)
;	       (lambda (l) (lex:read-char) (lex)))
;;; Ignore leading whitespace.
;(lex:def-class 0 (list slib:tab slib:form-feed #\  #\newline) #f)
