;;; -*- Base: 10; Mode: Scheme; Syntax: MIT Scheme; Package: USER -*-
;;
;; FILE.SCM
;;
;; July 15, 1991
;; Minghsun Liu
;;
;; File i/o related operations.
;;
;;
;; The following(s) are(is) defined:
;;
;; (WITH-OPEN-FILE PORT FILENAME OPTION . FORM)
;;

;;
;; (WITH-OPEN-FILE PORT FILENAME OPTION . FORM)
;;
;; opens a file with FILENAME for input or output.
;;
(defmacro (with-open-file port f-name option #!rest form)
  `(let ((,port ,(if (eq? option ':input)
		     `(open-input-file (string->pathname ,f-name))
		     `(open-output-file (string->pathname ,f-name)))))
     ,@form))


