/* $Header: cnet.c,v 1.6 91/03/21 16:39:04 clarsen Exp $ */
/* C interface to Scheme network code */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "objects.h"

new_sockaddr_in(s,family, port)
    struct sockaddr_in *s;
     int family, port;
{
    s->sin_family = family;
    s->sin_port = htons(port);
    s->sin_addr.s_addr = INADDR_ANY;
}

new_sockaddr_in_remote(s,family,port,host)
     struct sockaddr_in *s;
     int family, port;
     char *host;
{
    struct hostent *he;
/*    printf ("Host name is: %s\n",host);*/
    if (host != NULL) {
	if (!strcmp("any.any.any.any",host)) {
	    new_sockaddr_in(s,family,port);
	    s->sin_addr.s_addr = INADDR_ANY;
	} else if ((he = gethostbyname(host)) != NULL) {
	    new_sockaddr_in(s,family,port);
	    bcopy(he->h_addr,&s->sin_addr.s_addr,he->h_length);
	} else
	  perror (host);
    } else
      perror("(NULL)");
    
}

sock_matches(s1,s2)
     struct sockaddr_in * s1, *s2;
{
    return ((s1->sin_family == s2->sin_family) &&
            (s1->sin_port == s2->sin_port) &&
            (bcmp(&s1->sin_addr,&s2->sin_addr,sizeof(s1->sin_addr)) == 0))
	   ? 1 : 0;
}

fd_set *alloc_fdset()
{
    fd_set *fset = (fd_set *)malloc(sizeof(fd_set));
    FD_ZERO(fset);
    return fset;
}

fd_setfd(fdset,fd)
     fd_set *fdset;
     int fd;
{
    FD_SET(fd,fdset);
}
fd_clrfd(fdset,fd)
     fd_set *fdset;
     int fd;
{
    FD_CLR(fd,fdset);
}
fd_issetfd(fdset,fd)
     fd_set *fdset;
     int fd;
{
/*    printf ("%d is %d\n",fd,FD_ISSET(fd,fdset));*/
    return FD_ISSET(fd,fdset);
}
fd_zerofd(fdset)
     fd_set *fdset;
{
    FD_ZERO(fdset);
}
fd_set *select_default(fdset)
     fd_set *fdset;
{
    static fd_set tmp;
    struct timeval timeout;
    int nfds;
    timeout.tv_sec = 0;
    timeout.tv_usec = 1000; /* 1 ms */

    bcopy(fdset,&tmp,sizeof(tmp));
    if ((nfds = select(FD_SETSIZE,&tmp,&tmp,NULL,&timeout))<0) {
	perror("select");
    }
    return &tmp;
}
fd_set *select_read(fdset)
     fd_set *fdset;
{
    static fd_set tmp;
    struct timeval timeout;
    int nfds;
    timeout.tv_sec = 0;
    timeout.tv_usec = 1000; /* 1 ms */

    bcopy(fdset,&tmp,sizeof(tmp));
    if ((nfds = select(FD_SETSIZE,&tmp,NULL,NULL,&timeout))<0) {
	perror("select");
    }
    return &tmp;
}

/* Vector returned is:
 *         0:  family
 *         1:  port
 *         2:  low 2 byte of address in network byte order
 *         3:  high 2 bytes of address in network byte order
 */
TSCP sockaddr_attrs (sa)
     struct sockaddr_in *sa;
{
    TSCP v;
    PATSCP ve;
    v = sc_make_2dvector( C_FIXED(4),EMPTYLIST);
    ve = &(T_U(v)->vector.element0);
    *ve++ = C_FIXED( sa->sin_family);
    *ve++ = C_FIXED( sa->sin_port);
    *ve++ = C_FIXED( sa->sin_addr.s_addr & 0x0000FFFF );
    *ve++ = C_FIXED( (sa->sin_addr.s_addr >> 16) & 0x0000FFFF );
    return v;
}

/* normal scheme symbols are upper case */
upcase(s)
     char *s;
{
    while(*s) {
	if (*s >= 'a' && *s <= 'z') {
	    *s = 'A' + *s-'a';
	}
	s++;
    }
}

TSCP hostbyaddr(addrlow, addrhigh)
     TSCP addrlow, addrhigh;
{
    struct sockaddr_in adr;
    struct hostent *he;
    int high, low;
    high = sc_tscp_unsigned(addrhigh);
    low = sc_tscp_unsigned(addrlow);
    adr.sin_addr.s_addr = high << 16 | low;
/*    printf ("%lx\n",adr.sin_addr.s_addr);*/
    he = gethostbyaddr( &adr.sin_addr,sizeof(adr.sin_addr),AF_INET );
    if (he == NULL) {
	perror ("gethostbyaddr");
	return sc_emptystring;
    } else {
/*	printf ("%s\n",he->h_name);*/
	upcase(he->h_name);
	return (sc_cstringtostring(he->h_name));
    }
}

void dump_bytes(p)
     char *p;
{
    int i;
    for(i =0;i < 20; i++) {
	printf ("%d ",*p++);
    }
    putchar ('\n');
}
