; -*- Scheme -*-
;
; $Id: pathname20.scm,v 1.1 1993/02/19 00:49:23 bevan Exp $

(require 'pathname:+name)

;+doc
; procedure: pathname:+name-string
; arguments: pathname name
; signature: pathname string -> pathname
; 
; Creates a new pathname consisting of PATHNAME with the name
; overriden with NAME.  Some examples where P->S == PATHNAME->STRING
; and S->P == STRING->PATHNAME :-
;
; > (p->s (pathname+name-string (s->p "/usr/me/scm/pathname15.scm") "foo"))
; "/usr/me/scm/foo.scm"
;
; > (p->s (pathname+name-string (s->p "/usr/me/scm/.scm") "foo"))
; "/usr/me/scm/foo.scm"
;
; > (p->s (pathname+name-string (s->p "/usr/me/scm/.scm") "foo"))
; "/usr/me/scm/foo.scm"
;
; > (p->s (pathname+name-string (s->p "/usr/me/scm/") "foo"))
; "/usr/me/scm/foo"
;
; > (p->s (pathname+name-string (s->p "/usr/me/scm") "foo"))
; "/usr/me/foo"
;-doc

(define pathname:+name-string
  (lambda (p n)
    (pathname:+name p (if (zero? (string-length n)) #f n))))

; eof
