; -*- Scheme -*-
;
; $Id: pathname03.scm,v 1.1 1993/02/18 23:35:32 bevan Exp $
;
;------------
;
; Converts a string into a UNIX pathname
;
;------------

(require 'substring->unix:pathname:directory)
(require 'substring->unix:pathname:name+type)
(require 'pathname:make)

;------------

;+doc
; procedure: string->unix:pathname
; arguments: string
; signature: string -> pathname
;
; Regards STRING as a UNIX filename and converts it into a PATHNAME
;-doc

(define string->unix:pathname
  (let ((version #f) (host #f) (device #f))
    (lambda (s)
      (let ((sl (string-length s))
	    (k  (lambda (p name type)
		  (let ((directory 
			 (if (negative? p) 
			     #f
			     (substring->unix:pathname:directory s 0 p))))
		    (pathname:make host device directory name type version)))))
	(substring->unix:pathname:name+type s 0 sl (- sl 1) k)))))

; eof
