; -*- Scheme -*-
;
; $Id: pathname02.scm,v 1.1 1993/02/18 23:34:31 bevan Exp $
;
;-------------
;
; Extracts the (name,type) of a file from a string
;
;-------------

; procedure: substring->unix:pathname:name+type
; arguments: string start end current-position continuation
; signature: forall a
;         => string x int x int x int
;          x (int x (string|#f) x (string|#f) -> a)
;         -> a
; pre:     (and (<= 0 ss se (string-length string)) (< p se))
;
; Extracts the name and type of a file from STRING between START
; (inclusive) and END (exclusive).  CURRENT-POSITION is the position
; at which to start searching.  CONTINUATION is called with the
; position after the extraction is complete together with the name and
; type.

(define substring->unix:pathname:name+type
  (lambda (s ss se p k)
    (if (< p ss)
	(k p #f #f)
	(let ((c (string-ref s p)))
	  (cond ((char=? c #\.)
		 (let ((nk (lambda (np fn) (k np fn (substring s (+ p 1) se)))))
		   (substring->unix:pathname:name+type::. s ss p (- p 1) nk)))
		((char=? c #\/)
		 (k p (substring s (+ p 1) se) #f))
		(else
		 (substring->unix:pathname:name+type s ss se (- p 1) k)))))))


;------------

; procedure: substring->unix:pathname:name+type::.
; arguments: string start end current-position continuation
; signature: forall a
;         => string x int x int x int x (int x (string|#f) -> a) -> a
; pre:          (and (<= 0 ss se (string-length string)) (< p se))
; external-pre: (char=? #\. (string-ref string (+ current-position 1))))

(define substring->unix:pathname:name+type::.
  (lambda (s ss se p k)
    (if (< p ss)
	(k p (substring s ss se))
	(if (char=? #\/ (string-ref s p))
	    (k p (substring s (+ p 1) se))
	    (substring->unix:pathname:name+type::. s ss se (- p 1) k)))))

;------------

; eof
