; -*- Scheme -*-
;
; $Id: pathname00.scm,v 1.1 1993/02/18 23:33:29 bevan Exp $
;
;------------
;
; Access procedures for the PATHNAME type
;
;------------

;+doc
; procedure: pathname:host
; arguments: pathname
; signature: pathname -> pathname:host
;-doc

(define pathname:host (lambda (p) (vector-ref p 0)))

;------------

;+doc
; procedure: pathname:device
; arguments: pathname
; signature: pathname -> pathname:device
;-doc

(define pathname:device (lambda (p) (vector-ref p 1)))

;------------

;+doc
; procedure: pathname:directory
; arguments: pathname
; signature: pathname -> pathname:directory
;-doc

(define pathname:directory (lambda (p) (vector-ref p 2)))

;------------

;+doc
; procedure: pathname:name
; arguments: pathname
; signature: pathname -> pathname:name
;-doc

(define pathname:name (lambda (p) (vector-ref p 3)))

;------------

;+doc
; procedure: pathname:type
; arguments: pathname
; signature: pathname -> pathname:type
;-doc

(define pathname:type (lambda (p) (vector-ref p 4)))

;------------

;+doc
; procedure: pathname:version->string
; arguments: pathname
; signature: pathname -> pathname:version
;-doc

(define pathname:version (lambda (p) (vector-ref p 5)))

; eof
