;; -*- Scheme -*-
;;
;; $Id: stringt20.scm,v 1.2 1993/10/22 13:22:43 bevan Exp $

(require 'string:test:equal)
(require 'substring:center)
(require 'string:center)

(define substring:test:center
  (lambda args

    (if (not (null? args)) (display "Testing substring:center ... "))

    (string:test:equal
      'substring:test:center-a
      (substring:center "Detroit" 0 7 10 "+")
      "+Detroit++")

    (string:test:equal
      'substring:test:center-b
      (substring:center "Detroit" 0 7 20 "+*+")
      "+*++*+Detroit+*++*++")

    (string:test:equal
      'substring:test:center-c
      (substring:center "Detroit" 3 7 10 "+*+")
      "+*+roit+*+")

    (string:test:equal
      'substring:test:center-d
      (substring:center "Detroit" 3 7 10 "+*+")
      "+*+roit+*+")

    (if (not (null? args)) (begin (display "done") (newline)))

    ))


(define string:test:center
  (lambda args

    (if (not (null? args)) (display "Testing string:center ... "))

    (string:test:equal
      'string:test:center-a
      (string:center "Detroit" 10 "+")
      "+Detroit++")

    (string:test:equal
      'string:test:center-b
      (string:center "Detroit" 20 "+*+")
      "+*++*+Detroit+*++*++")

    (if (not (null? args)) (begin (display "done") (newline)))

    ))

;; eof
