;; -*- Scheme -*-
;;
;; $Id$

(require 'substring:read!)

;;+doc
;; procedure: string:read
;; arguments: port count
;; signature: port x int -> string
;; pre:       (input-port? port)
;;
;; Read COUNT characters from PORT and return them in a string.
;; If there aren't COUNT characters left in the PORT, then the string
;; will contain the number of characters actually read.
;;-doc
;; This operation is not very efficient in portable Scheme since it
;; effectively requires a string copy if there aren't enough characters
;; whereas in something lower level, it would be possible to just ignore
;; the space at the end of the string and fudge the length.

(define string:read
  (lambda (p n)
    (let* ((s (make-string n))
	   (e (substring:read! p s 0 n)))
      (if (= e n)
	  s
	  (substring s 0 e)))))

;; eof
