; -*- Scheme -*-
;
; $Id: string52.scm,v 1.1 1993/08/28 12:27:27 bevan Exp $

(require 'substring:trim-right-by-proc-pos)
(require 'substring:trim-left-by-proc-pos)

;+doc
; procedure: string:trim-by-proc
; arguments: string proc
; signature: string x (char -> bool) -> string
;
; Trims all characters that satisfy PROC off both ends of STRING and
; return the new string. 
;
; > (string:trim-with-char "   abcd efgh   " char-whitespace?)
; "abcd efgh"
; > (string:trim-with-char "     " char-whitespace?)
; ""
;-doc

(define string:trim-by-proc
  (lambda (s p)
    (let ((sl (string-length s)))
      (let ((l (substring:trim-left-by-proc-pos s 0 sl p)))
	(if (= l sl)
	    ""
	    (let ((r (substring:trim-right-by-proc-pos s l sl p)))
	      (substring s l r)))))))

; eof
