; -*- Scheme -*-
;
; $Id: string50.scm,v 1.1 1993/08/28 12:27:02 bevan Exp $

(require 'substring:trim-right-pos-with-chars)
(require 'substring:trim-left-pos-with-chars)

;+doc
; procedure: string:trim-with-chars
; arguments: string chars
; signature: string x char-set -> string
;
; Trims CHARS off both ends of STRING and return the new string.
;
; > (string:trim-with-chars "   abcd efgh   " char-set:whitespace)
; "abcd efgh"
; > (string:trim-with-chars "     " char-set:whitespace)
; ""
;-doc

(define string:trim-with-chars
  (lambda (s cs)
    (let ((sl (string-length s)))
      (let ((l (substring:trim-left-pos-with-chars s 0 sl cs)))
	(if (= l sl)
	    ""
	   (let ((r (substring:trim-right-pos-with-chars s l sl cs)))
	     (substring s l r)))))))

; eof
