; -*- Scheme -*-
;
; $Id: string49.scm,v 1.1 1993/08/28 12:29:25 bevan Exp $

;------------

(require 'string:trim-with-char)
(require 'string:trim-with-chars)
(require 'string:trim-by-proc)
(require 'char-set:whitespace)

;------------

;+doc
; procedure: string:trim
; arguments: string chars
; signature: string x char-set -> string
; arguments: string char
; signature: string x char -> string
; arguments: string string
; signature: string x string -> string
; arguments: string proc
; signature: string x (char -> bool) -> string
; arguments: string
; signature: string -> string
;
; Return a fresh copy of STRING with certain characters removed from
; both ends.  Various methods of trimming are supported.  These
; are trimming using :-
; 
;  * a char-set to define all the characters to be removed
;  * a single character defining the character to be removed
;  * a string which is converted into a char-set and then used.
;  * a procedure which should return #t for any character to be removed.
;  * whitespace if no method of trimming is supplied.
;
; Three different ways of removing whitespace :-
;
;  > (string:trim "  Betelgeuse   ")
;  "Betelgeuse"
;  > (string:trim "  Betelgeuse   " char-whitespace?)
;  "Betelgeuse"
;  > (string:trim "  Betelgeuse   " char-set:whitespace)
;  "Betelgeuse"
;-doc

(define string:trim
  (lambda (string . opt)
    (let ((m (if (null? opt) char-set:whitespace (car opt))))
      (cond
       ((char-set? m) (string:trim-with-chars string m))
       ((string? m) (string:trim-with-chars string (string->char-set m)))
       ((char? m) (string:trim-with-char string m))
       ((procedure? m) (string:trim-by-proc string m))
       (else (error 'string:trim "invalid trim method"))))))

; eof
