; -*- Scheme -*-
;
; $Id: string45.scm,v 1.1 1993/08/28 12:28:37 bevan Exp $

;------------

(require 'char-set?)
(require 'char-set:whitespace)
(require 'string->char-set)
(require 'string:trim-right-with-chars)
(require 'string:trim-right-with-char)
(require 'string:trim-right-by-proc)

;------------

;+doc
; procedure: string:trim-right
; arguments: string chars
; signature: string x char-set -> string
; arguments: string char
; signature: string x char -> string
; arguments: string string
; signature: string x string -> string
; arguments: string proc
; signature: string x (char -> bool) -> string
; arguments: string
; signature: string -> string
;
; Return a fresh copy of STRING with certain characters removed from
; the right end.  Various methods of trimming are supported.  These
; are trimming using :-
; 
;  * a char-set to define all the characters to be removed
;  * a single character defining the character to be removed
;  * a string which is converted into a char-set and then used.
;  * a procedure which should return #t for any character to be removed.
;  * whitespace if no method of trimming is supplied.
;
; Examples:
;
; Three different ways of removing whitespace :-
;
; > (string:trim-right "Betelgeuse   ")
; "Betelgeuse"
; > (string:trim-right "Betelgeuse   " char-whitespace?)
; "Betelgeuse"
; > (string:trim-right "Betelgeuse   " char-set:whitespace)
; "Betelgeuse"
;-doc

(define string:trim-right
  (lambda (string . opt)
    (let ((m (if (null? opt) char-set:whitespace (car opt))))
      (cond ((char-set? m) (string:trim-right-with-chars string m))
	    ((string? m) (string:trim-right-with-chars string (string->char-set m)))
	    ((char? m) (string:trim-right-with-char string m))
	    ((procedure? m) (string:trim-right-by-proc string m))
	    (else (error 'string:trim-right "invalid trim method"))))))

; eof
