; -*- Scheme -*-
;
; $Id: string42.scm,v 1.1 1993/08/28 12:28:13 bevan Exp $

;+doc
; procedure: substring:find-char-r->l
; arguments: string start end char if-found if-not-found state
; signature:
;    forall a => string x char x int x int x (int x (a -> a) x a) x a -> a
; pre:       (<= start end (string-length string))
;
; Searches STRING from right to left between START (inclusive) and END
; (exclusive) looking for CHAR.  If CHAR is found, IF-FOUND is called
; with the position at which the character was found, a continuation
; which if called will find the next position of the character and the
; STATE of the system.
;-doc

(define substring:find-char-r->l
  (lambda (s ss se c if-found if-not-found st)
    (if (= ss se)
	(if-not-found st)
	(let loop ((p (- se 1)) (ns st))
	  (cond ((< p ss) (if-not-found ns))
		((char=? c (string-ref s p))
		 (if-found p (lambda (s) (loop (- p 1) s)) ns))
		(else (loop (- p 1) ns)))))))

;------------

;+doc
; procedure: string:find-char-r->l
; arguments: string char if-found if-not-found state
; signature: forall a
;         => string x char x (int x (a -> a) x a) x (a -> a) x a -> a
;
; Searches STRING from right to left looking for CHAR.  If CHAR is found,
; IF-FOUND is called with the position at which the character was
; found, a continuation which if called will find the next position of
; the character and the STATE of the system.
;-doc

(define string:find-char-r->l
  (lambda (s c yes no r)
    (substring:find-char-r->l s 0 (string-length s) c yes no r)))

; eof
