; -*- Scheme -*-
;
; $Id: string41.scm,v 1.1 1993/08/28 12:26:31 bevan Exp $

;+doc
; procedure: substring:trim-left-pos-with-char
; arguments: source start end char
; signature: string x int x int x char -> int
; pre:       (<= 0 start end (string-length source))
;
; Returns the position of the first character in SOURCE starting at
; START (inclusive) and ending at END (exclusive) which is not CHAR.
;
; > (substring:trim-left-pos-with-char "  some chars " 0 18 #\space)
; 2
;
; > (substring:trim-left-pos-with-char "---- chars" 0 15 #\-)
; 4
;-doc

(define substring:trim-left-pos-with-char
  (lambda (s ss se c)
    (let loop ((i ss))
      (if (and (< i se) (char=? c (string-ref s i))) (loop (+ 1 i)) i))))

;-------------

;+doc
; procedure: substring:trim-left-with-char
; arguments: source start end char
; signature: string x int x int x char -> string
; pre:       (<= 0 start end (string-length source))
;
; Returns a string consisting of SOURCE between START (inclusive) and
; END (exclusive) CHAR stripped of the left side. 
;
; > (substring:trim-left-with-char "  some characters " 0 18 #\space)
; "some characters "
;
; > (substring:trim-left-with-char "---- characters" 0 15 #\-)
; " characters"
;-doc

(define substring:trim-left-with-char
  (lambda (s ss se c)
    (substring s (substring:trim-left-pos-with-char s ss se c) se)))

;------------

;+doc
; procedure: string:trim-left-with-char
; arguments: source char
; signature: string x char -> string
;
; Returns a string consisting of SOURCE with CHAR removed from start.
;
; > (string:trim-left-with-char "  some characters " #\space)
; "some characters "
;
; > (string:trim-left-with-char "---- characters" #\-)
; " characters"
;-doc

(define string:trim-left-with-char
  (lambda (s cs)
    (let ((sl (string-length s)))
      (if (zero? sl)
	  ""
	  (substring:trim-left-with-char s 0 sl cs)))))

; eof
