; -*- Scheme -*-
;
; $Id: string24.scm,v 1.2 1993/10/11 15:55:15 bevan Exp $

(require 'char-set:member?)

;+doc
; procedure: substring:find-chars
; arguments: string start end chars if-found if-not-found state
; signature: 
;   forall a => string x int x int char-set x (int x (a -> a) x a) x a -> a
; pre:       (<= 0 start end (string-length string))
;
; Searches STRING in order from START (inclusive) to END (exclusive)
; looking for any characters that are in CHARS.  If a character is
; found, IF-FOUND is called with the position of the character, a
; continuation which if called will find the position of the next
; matching character and the STATE of the system.  If the search extends
; past END, then IF-NOT-FOUND is called with the STATE at that point.
;
; Based on the Icon function `upto(c, s, i, j)'
;-doc

(define substring:find-chars
  (lambda (source start end chars if-found if-not-found state)
    (let loop ((cp start) (r state))
      (cond
        ((>= cp end) (if-not-found r))
	((char-set:member? chars (string-ref source cp))
	   (let ((np (lambda (r) (loop (+ 1 cp) r))))
	     (if-found cp np r)))
	(else (loop (+ 1 cp) r))))))

;-------------

;+doc
; procedure: string:find-chars
; arguments: string chars if-found if-not-found state
; signature: forall a => string char-set x (int x (a -> a) x a) x a -> a
;
; Searches STRING in order looking for any characters that are in
; CHARS.  If a character is found, IF-FOUND is called with the
; position of the character, a continuation which if called will find
; the position of the next matching character and the STATE of the
; system. 
;
; Based on the Icon function `upto(c, s, i, j)'
;-doc

(define string:find-chars
  (lambda (s cs if-found if-not-found st)
    (substring:find-chars s 0 (string-length s) cs if-found if-not-found st)))


; eof
