; -*- Scheme -*-
;
; $Id: string22.scm,v 1.2 1993/10/11 14:51:01 bevan Exp $

;+doc
; procedure: substring:find-char
; arguments: string start end char if-found if-not-found state
; signature: forall a => string x int x int x char
;                      x (int x (a -> a) x a)
;                      x (a -> a)
;                      x a
;                     -> a
; pre:       (<= start end (string-length string))
;
; Searches STRING in order between START (inclusive) and END
; (exclusive) looking for CHAR.  If CHAR is found, IF-FOUND is called
; with the position at which the character was found, a continuation
; which if called will find the next position of the character and the
; STATE of the system.
;
; This is a special case of the Icon functions `find(s1, s2, i, j)'
; and `upto(c, s, i, j)', where CHAR is considered
; as a string containing one character for `find' or a character set
; containing one character for `upto'
;-doc

(define substring:find-char
  (lambda (s ss se c if-found if-not-found r)
    (let loop ((i ss) (r r))
      (cond ((>= i se) (if-not-found r))
	    ((char=? c (string-ref s i))
	     (if-found i (lambda (s) (loop (+ 1 i) s)) r))
	    (else (loop (+ 1 i) r))))))

;-------------

;+doc
; procedure: string:find-char
; arguments: string char if-found if-not-found state
; signature: forall a => string x char x (int x (a->a) x a) x (a->a) x a->a
;
; Searches STRING in order looking for CHAR.  If CHAR is found,
; IF-FOUND is called with the position at which the character was
; found, a continuation which if called will find the next position of
; the character and the STATE of the system.
;
; This is a special case of the Icon functions `find(s1, s2, i, j)'
; and `upto(c, s, i, j)', where CHAR is considered
; as a string containing one character for `find' or a character set
; containing one character for `upto'
;-doc

(define string:find-char
  (lambda (s c yes no r)
    (substring:find-char s 0 (string-length s) c yes no r)))

; eof
