; -*- Scheme -*-
;
; $Id: string14.scm,v 1.2 1993/10/22 13:25:46 bevan Exp $

(require 'string:copy)
(require 'substring:upcase!)
(require 'string:upcase!)

;+doc
; procedure: substring:upcase
; arguments: string start end
; signature: string x int x int -> string
; pre:       (<= 0 start end (string-length string))
;
; Returns a copy of STRING with every case-modifiable character
; betweeen START (inclusive) and END (exclusive) is coverted to
; upper case.
;
; > (substring:upcase "occlUDed cASEmenTs" 0 18)
; "OCCLUDED CASEMENTS"
;
; > (substring:upcase "occlUDed cASEmenTs" 5 18)
; "occlUDED CASEMENTS"
;
; > (substring:upcase "occlUDed cASEmenTs" 5 15)
; "occlUDED CASEMEnTs"
;-doc

(define substring:upcase
  (lambda (s ss se)
    (let ((r (string:copy s)))
      (substring:upcase! r ss se)
      r)))


;+doc
; procedure: substring:upcase
; arguments: string
; signature: string -> string
;
; Returns a copy of STRING with every case-modifiable character
; betweeen START and END is coverted to lowercase.
;
; > (substring:upcase "occlUDed cASEmenTs")
; "OCCLUDED CASEMENTS"
;-doc

(define string:upcase
  (lambda (s)
    (let ((r (string:copy s)))
      (string:upcase! r)
      r)))

; eof
