; -*- Scheme -*-
;
; $Id: string07.scm,v 1.1 1993/08/28 12:31:05 bevan Exp $

;+doc
; procedure: string:copy
; arguments: string
; signature: string -> string
;
; Returns a copy of STRING.  This is a standard Scheme procedure under
; the name STRING-COPY, but some older systems don't implement it, so
; this hides the incompatibility by defining a portable version if
; STRING-COPY is not implemented.
;-doc

(define string:copy string-copy)

;(define string:copy
;  (lambda (original)
;    (substring original 0 (string-length original))

; Copy by using SUBSTRING since it is guaranteed to produce a fresh
; copy of the string.


;(define string:copy
;  (lambda (original)
;    (let* ((original-length (string-length original))
;	   (result (make-string original-length)))
;      (let loop ((pos 0))
;	(if (= pos original-length)
;	    result
;	    (begin
;	      (string-set! result pos (string-ref original pos))
;	      (loop (+ 1 pos))))))))

; Do an explicit copy character by character.

; eof
