; -*- Scheme -*-
;
; $Id: string02.scm,v 1.2 1993/10/24 17:10:59 bevan Exp $


;+doc
; procedure: substring:read!
; arguments: port string start end
; signature: port x string x int x int -> int
; pre:       (and (input-port? port) (<= 0 start end (string-length string)))
;
; Read (- END (+ START 1)) characters from PORT and store them in
; STRING at position START (inclusive) through to END (exclusive).
; Returns the position of the last character read in.  Consequently if
; no characters are actually read, the result will equal START.
;-doc

(define substring:read!
  (lambda (port string start end)
    (if (= start end)
	start
	(let ((chr (read-char port)))
	  (if (eof-object? chr)
	      start
	      (begin
		(string-set! string start chr)
		(substring:read! port string (+ 1 start) end)))))))

; This is a portable version which works by reading a char at a time
; from the port.  For efficiency, you really want this implemented
; directly by the Scheme system (e.g. direct call to fread/read in C/UNIX).

; eof
