; -*- Scheme -*-
;
; $Id$

(require 'char-set:make)
(require 'char-set:insert!)

;+doc
; procedure: string->char-set
; arguments: string
; signature: string -> char-set
; 
; Converts STRING into a CHAR-SET i.e. every character in the string
; is added to the character set.
;-doc

(define string->char-set
  (lambda (s)
    (let ((r (char-set:make)) (sl (string-length s)))
      (let loop ((i 0))
	(if (= i sl)
	    r
	    (begin (char-set:insert! r (string-ref s i)) (loop (+ i 1))))))))

; eof
