; -*- Scheme -*-
;
; $Id$

(require 'char-set::vector-size)
(require 'char-set:make)

;+doc
; procedure: char-set:copy
; arguments: char-set
; signature: char-set -> char-set
;
; Returns a copy of CHAR-SET
;-doc

(define char-set:copy
  (lambda (s)
    (let ((r (char-set:make)))
      (let loop ((i 0))
	(if (= i char-set::vector-size)
	    r
	    (begin (vector-set! r i (char-set::at s i)) (loop (+ 1 i))))))))

; eof
