; -*- Scheme -*-
;
; $Id$

(require 'char-set:make)
(require 'char-set:insert!)

;+doc
; procedure: char-set:from-list
; arguments: list
; signature: list[int] -> char-set
; pre:       (andmap (lambda (i) (<= 0 i 255)) list)
;
; Creates a new char-set which contains all the characters whose ASCII
; codes are given in LIST
;-doc

(define char-set:from-integer-list
  (lambda (ints)
    (let ((set (char-set:make)))
      (let loop ((l ints))
	(if (null? l)
	    set
	    (begin
	      (char-set:insert! set (integer->char (car l)))
	      (loop (cdr l))))))))

; eof
