; -*- Scheme -*-
;
; $Id$

;------------

(require 'char-set::vector-size)
(require 'char-set::at)
(require 'char-set::1+size!)

;+doc
; procedure: char-set:union!
; arguments: a b
; signature: char-set x char-set -> unspecified
;
; Modifies A such that it contains the union of A and B
;-doc

(define char-set:union!
  (lambda (a b)
    (let loop ((i (- char-set::vector-size 1)))
      (if (not (zero? i))
	  (begin
	    (if (and (char-set::at b i) (not (char-set::at a i)))
		(begin (vector-set! a i #t) (char-set::1+size! a)))
	    (loop (- i 1)))))))

; eof
