;; -*- Scheme -*-
;;
;; $Id: avl-treet11.scm,v 1.1 1993/10/23 14:37:09 bevan Exp $
;;

(require 'avl-tree:from-list)
(require 'avl-tree->list-in-order)
(require 'avl-tree:test:equal)

(define avl-tree:test:from-list
  (lambda args
    (let ((->l avl-tree->list-in-order)
	  (l-> avl-tree:from-list))

      (if (not (null? args)) (display "Testing avl-tree:from-list ... "))

      (avl-tree:test:equal
       'avl-tree:from-list-a
       (->l (l-> '(1 2 3 4) (lambda (id) id) < (lambda (o n) n)))
       '(1 2 3 4))

      (avl-tree:test:equal
       'avl-tree:from-list-b
       (->l (l-> '(("phone" . 6270) ("fax" . 6280) ("phone" . 8066)) car string<? (lambda (o n) o)))
       '(("fax" . 6280) ("phone" . 6270)))

      (avl-tree:test:equal
       'avl-tree:from-list-c
       (->l (l-> '(("phone" . 6270) ("fax" . 6280) ("phone" . 8066)) car string<? (lambda (o n) n)))
       '(("fax" . 6280) ("phone" . 8066)))

      (if (not (null? args)) (begin (display "done") (newline)))

      )))

;; eof
