;; -*- Scheme -*-
;;
;; $Id: avl-tree07.scm,v 1.2 1993/10/27 15:45:10 bevan Exp $

;;-------------

(require 'avl-tree:find)

;;-------------

;;+doc
;; procedure: avl-tree:lookup
;; arguments: tree key unwrap-key <?
;; signature: forall a,b,c => avl-tree[a,b,c] x a x (c -> a) x (a x a -> bool)
;;                         -> bool
;;
;; Returns #t/#f depending on whether an element with the given KEY is
;; in the TREE.
;;-doc

(define avl-tree:lookup
  (let ((id (lambda (id) id)) (fail (lambda (_) #f)))
    (lambda (t k uk <?)
      (avl-tree:find t k uk <? id fail))))

;; eof
