;;;;
;;;; $Id: top-level.scm,v 1.6 1992/10/30 13:14:52 pk Exp $
;;;;
;;;; sclint -- a Scheme lint.
;;;;
;;;; Pertti Kellom\"aki, 1992
;;;;
;;;; $Log: top-level.scm,v $
;;;; Revision 1.6  1992/10/30  13:14:52  pk
;;;; PC-Scheme does not like make-environment as variable name. Changed to make-env.
;;;;
;;;; Revision 1.5  1992/10/30  07:35:51  pk
;;;; Changed scope of r4rs names from 'global to 'builtin.
;;;;
;;;; Revision 1.4  1992/10/23  13:41:07  pk
;;;; Attach information about the procedure to the global procedure definitions.
;;;;
;;;; Revision 1.3  1992/10/22  12:59:54  pk
;;;; R4RS names are now global symbols with no location.
;;;; Removed duplicate - from r4rs names, caught by sclint itself.
;;;; Removed duplicate definition of definition-name. Now defined only in procs.scm.
;;;;
;;;; Revision 1.2  1992/10/17  11:28:59  pk
;;;; Added r4rs names to the top level environment.
;;;;
;;;; Revision 1.1  1992/09/22  07:23:12  pk
;;;; Initial revision
;;;;
;;;; 

;;;;
;;;; These procedures collect information about the top-level names in
;;;; the program. The top-level environment is also created here.
;;;;

;;;
;;; Build the top-level environment.
;;;

(define (build-top-level-environment program)
  (make-env #f (append (top-level-names program)
			       (map (lambda (name)
				      (make-variable (psd-make-symbol #f #f name) 'builtin))
				    r4rs-names))))

(define r4rs-names
  '(* + - / < <= = > >= abs acos angle append apply asin assoc assq assv
      atan boolean? caaaar caaadr caaar caadar caaddr caadr caar cadaar
      cadadr cadar caddar cadddr caddr cadr call-with-current-continuation
      call-with-input-file call-with-output-file car cdaaar cdaadr cdaar
      cdadar cdaddr cdadr cdar cddaar cddadr cddar cdddar cddddr cdddr cddr
      cdr ceiling char->integer char-alphabetic? char-ci<=? char-ci<?
      char-ci=? char-ci>=? char-ci>? char-downcase char-lower-case?
      char-numeric? char-ready? char-upcase char-upper-case?
      char-whitespace? char<=? char<? char=? char>=? char>? char?
      close-input-port close-output-port complex? cons cos
      current-input-port current-output-port denominator display eof-object?
      eq? equal? eqv? even? exact->inexact exact? exp expt floor for-each
      force gcd imag-part inexact->exact inexact? input-port? integer->char
      integer? lcm length list list->string list->vector list-ref list-tail
      list? load log magnitude make-polar make-rectangular make-string
      make-vector map max member memq memv min modulo negative? newline not
      null? number->string number? numerator odd? open-input-file
      open-output-file output-port? pair? peek-char positive? procedure?
      quotient rational? rationalize read read-char real-part real?
      remainder reverse round set-car! set-cdr! sin sqrt string string->list
      string->number string->symbol string-append string-ci<=? string-ci<?
      string-ci=? string-ci>=? string-ci>? string-copy string-fill!
      string-length string-ref string-set! string<=? string<? string=?
      string>=? string>? string? substring symbol->string symbol? tan
      transcript-off transcript-on truncate vector vector->list vector-fill!
      vector-length vector-ref vector-set! vector? with-input-from-file
      with-output-to-file write write-char zero?))

;;;
;;; Find all the top level names that are defined in the program.
;;;

(define (top-level-names program)

  (let loop ((program program)
	     (names '()))
    (cond ((null? program)
	   names)
	  ((match '(define symbol expr*) (car program))
	   (loop (cdr program)
		 (cons (make-variable (cadr (match-result)) 'global)
		       names)))
	  ((match '(define (symbol expr*) expr*) (car program))
	   (loop (cdr program)
		 (let ((proc (make-variable (caadr (match-result)) 'global)))
		   (variable-set-parameter-info! proc
						 (parameter-info
						  (psd-cdr (psd-cadr (car program)))))
		   (cons proc
			 names))))
	  (else
	   (loop (cdr program)
		 names)))))
      
;;;
;;; Try to find the top level procedures that are defined in the
;;; program. This handles only definitions that are defined using
;;; 
;;;    (define (foo x) ...)
;;; or
;;;    (define foo (lambda (x) ...))
;;;
;;; A more detailed analysis would require at least partial type
;;; checking. A list of
;;;
;;;   (procedure-name argument-count &rest)
;;;
;;; triples is returned, where argument-count is the required number
;;; of arguments and &rest is either #t or #f depeding on whether the
;;; procedure takes optional arguments.

(define (top-level-procedures program)

  (define (definition-info form)

    ;; the number of arguments
    (define (arg-count args)
      (let loop ((args args)
		 (count 0))
	(if (pair? args)
	    (loop (cdr args)
		  (+ count 1))
	    count)))

    ;; is there a rest argument?
    (define (rest-arg? args)
      (let loop ((args args))
	(cond ((pair? args)
	       (loop (cdr args)))
	      ((null? args)
	       #f)
	      (else #t))))

    (if (and (psd-pair? (psd-cdr form))
	     (psd-pair? (psd-cddr form)))

	;; this at least has the potential of being a procedure
	;; definition 
	(if (psd-pair? (psd-car (psd-cdr form)))
	    
	    ;; we have a (define (foo x) ...)
	    (let* ((heading (psd-cadr form))
		   (proc-name (psd-expr-contents (psd-car heading)))
		   (args (psd-map psd-expr-contents (psd-cdr heading))))
	      (list proc-name
		    (arg-count args)
		    (rest-arg? args)))
	
	    ;; we have a (define foo ...), check if the expression is a
	    ;; lambda form
	    (let ((body (psd-caddr form)))
	      (if (and (psd-pair? body)
		       (equal? (pexp->sexp (psd-car body))
			       'lambda))

		  ;; it is, go for the arguments
		  (let* ((proc-name (pexp->sexp (psd-cadr form)))
			 (args (pexp->sexp (psd-cadr body))))
		    (list proc-name
			  (arg-count args)
			  (rest-arg? args)))

		  ;; it was probably not a procedure after all
		  #f)))

	;; there was something wrong with the definition
	#f))

  (let loop ((program program)
	     (result '()))
    (cond ((null? program)
	   result)
	  ((and (psd-pair? (car program))
		(equal? (pexp->sexp (psd-car (car program)))
			
			'define))
	   (let ((info (definition-info (car program))))
	     (if info
		 (loop (cdr program)
		       (cons info
			     result))
		 (loop (cdr program)
		       result))))
	  (else
	   (loop (cdr program)
		 result)))))

