;;;;
;;;; $Id: sclint.scm,v 1.7 1992/10/30 13:12:58 pk Exp pk $
;;;;
;;;; sclint -- a Scheme lint.
;;;;
;;;; Pertti Kellom\"aki, 1992
;;;;
;;;; $Log: sclint.scm,v $
;;;; Revision 1.7  1992/10/30  13:12:58  pk
;;;; Added some verbosity.
;;;; Now uses psd-reset-read instead of directly setting global variables.
;;;;
;;;; Revision 1.6  1992/09/22  07:18:30  pk
;;;; Now does indentation checks.
;;;;
;;;; Revision 1.5  1992/09/17  08:58:56  pk
;;;; Fixed a bug in inserting warnings into the warning list.
;;;;
;;;; Revision 1.4  1992/09/03  13:58:08  pk
;;;; Now collects info about the top level names.
;;;;
;;;; Revision 1.3  1992/09/03  08:39:52  pk
;;;; Displays the complaints file by file in sorted order.
;;;;
;;;; Revision 1.2  1992/09/02  12:03:00  pk
;;;; Complaints about each file are stored separately.
;;;;
;;;; Revision 1.1  1992/08/27  12:18:37  pk
;;;; Initial revision
;;;;
;;;;

;;;;
;;;; We want to inline the accessor procedures for pexprs.
;;;;
(define compile-inline
  '(psd-make-expr psd-expr-type psd-expr-start psd-expr-end
		  psd-expr-contents psd-expr-start-file
		  psd-expr-start-line psd-expr-start-column
		  psd-expr-file psd-expr-end-line psd-expr-end-column
		  psd-make-null psd-null? psd-cons psd-pair? psd-car
		  psd-cdr psd-cadr psd-caddr psd-cddr psd-cdddr
		  psd-caar psd-cadar psd-make-symbol psd-symbol?
		  psd-make-number psd-number? psd-make-boolean
		  psd-boolean? psd-make-string psd-string?
		  psd-make-char psd-char? psd-make-vector psd-vector?
		  psd-vector-contents))

;(load "pexpr-inline.scm")
;(load "read.scm")
;(load "special.scm")
;(load "indent.scm")

;;;;
;;;; This is the driver file for sclint. It reads in a Scheme program
;;;; and performs various checks on it.
;;;;

(define (file-definitions port file-name)
  (let ((expr (psd-read port file-name)))
    (if (eof-object? expr)
	'()
	(cons expr (file-definitions port file-name)))))

(define (sclint-loop file-names program)
  (cond ((null? file-names)
	 (display "done.")
	 (newline)
	 (perform-checks (reverse program))
	 (report-warnings))
	(else
	 (display (car file-names))
	 (display ", ")
	 (psd-reset-read)
	 (let* ((port (open-input-file (car file-names)))
		(definitions (file-definitions port (car file-names))))
	   (close-input-port port)
	   (sclint-loop (cdr file-names)
			(append definitions program))))))

(define (sclint file-names)
  (display "sclint v. 0.9, Pertti Kellomaki 1992")
  (newline)
  (display "Reading source files: ")
  (sclint-loop file-names '()))

;;;
;;; Perform the actual checks.
;;;

(define (perform-checks program)

  ;; check the indentation
  (display "Checking indentation...")
  (map (lambda (form)
	 (check-indentation form 1))
       program)
  (display "done.")
  (newline)

  ;; argument count checks etc.
  (display "Checking special forms and argument counts...")
  (let ((environment (build-top-level-environment program)))
    (map (lambda (expr)
	   (check-argument-counts expr environment))
	 program)
    #f)
  (display "done.")
  (newline))


;;;
;;; Accumulate and issue warnings. Warnings for each file
;;; are stored in a separate list in reverse order. Each list looks
;;; like
;;;
;;;    (file-name (line-number complaint) (line-number complaint) ...)
;;;

(define warnings '())

;; store a warning
(define warning
  (lambda (form . complaints)

    (let* ((file-name (psd-index->path (car (psd-expr-start form))))
	   (line-number (cadr (psd-expr-start form)))
	   (trial (assoc file-name warnings))
	   (entry (if trial
		      
		      ;; we found an entry for this file
		      trial
		      
		      ;; else we have to make a new one
		      (begin
			(let ((new-entry (list file-name)))
			  (set! warnings (cons new-entry warnings))
			  new-entry)))))
      
      (define (loop prev this)
	(cond ((null? this)
	     
	       ;; end of list
	       (set-cdr! prev
			 (list (cons line-number complaints))))

	      ;; is this the right place?
	      ((> line-number (caar this))
	       (set-cdr! prev
			 (cons (cons line-number complaints)
			       this)))

	      (else
	       (loop (cdr prev)
		     (cdr this)))))
	  
      ;; splice the warning into the list
      (loop entry (cdr entry)))))


;; report-warnings
(define report-warnings
  (lambda ()
    (for-each (lambda (entry)
		(let ((file-name (car entry)))
		  (for-each (lambda (x)
			      (display file-name)
			      (display ":")
			      (display (car x))
			      (display ":")
			      (for-each (lambda (obj) (display obj))
					(cdr x))
			      (newline))
			    (reverse (cdr entry)))))
	      warnings)))
	 


  
