;;;;
;;;; $Id: checkarg.scm,v 1.7 1993/03/08 09:32:52 pk Exp $
;;;;
;;;; sclint -- a Scheme lint.
;;;;
;;;; Pertti Kellom\"aki, 1992
;;;;
;;;; $Log: checkarg.scm,v $
;;;; Revision 1.7  1993/03/08  09:32:52  pk
;;;; Added detection of unused variables.
;;;;
;;;; Revision 1.6  1992/10/30  07:32:43  pk
;;;; Removed some debugging output.
;;;;
;;;; Revision 1.5  1992/10/23  13:34:04  pk
;;;; Checks that a procedure is called with a correct number of arguments,
;;;; provided that sclint has been able to figure out how the procedure was defined.
;;;;
;;;; Revision 1.4  1992/10/17  11:26:12  pk
;;;; Better handling of primitive procedures.
;;;;
;;;; Revision 1.3  1992/09/03  13:55:57  pk
;;;; Now complains about variables that are not defined in the top level
;;;; environment. Does not understand local variables yet.
;;;;
;;;; Revision 1.2  1992/09/03  06:53:27  pk
;;;; Moved checking of special forms to special.scm.
;;;;
;;;; Revision 1.1  1992/08/27  12:22:28  pk
;;;; Initial revision
;;;;
;;;;

;;;;
;;;; Check that procedure calls are made with the correct
;;;; number of arguments, or that a special form has the right number
;;;; of subexpressions.
;;;;

(define (check-argument-counts form environment)
  (cond ((psd-pair? form)
         (cond ((special-form? form)
                (check-special-form form environment))
               (else
		(check-sequence (psd-cdr form) environment)
		(if (primitive-procedure? (psd-car form))
		    (check-primitive-call form environment)
		    (check-procedure-call form environment)))))
        ((psd-symbol? form)
	 (let ((variable (lookup environment (pexp->sexp form))))
	   (if variable
	       (variable-add-reference! variable form)
	       (warning form "Variable not defined in lexical context: " (pexp->sexp form)))))
        (else #f)))


;;;
;;; Recognize a special form.
;;;

(define (special-form? form)
  (member (pexp->sexp (psd-car form))
          '(=> do or and else quasiquote
               begin if quote case lambda set!
               cond let unquote define let*
               unquote-splicing delay letrec)))

;;;
;;; Check a procedure call.
;;;

(define (check-procedure-call form environment)
  (psd-map (lambda (pexp)
             (check-argument-counts pexp environment))
           (psd-cdr form))
  (cond ((psd-symbol? (psd-car form))
	 (let ((proc (lookup environment (pexp->sexp (psd-car form)))))
	   (if proc
	       (if (variable-procedure? proc)
		   (if (variable-rest-parameter? proc)
		       (if (< (length (pexp->sexp (psd-cdr form)))
			      (variable-parameter-count proc))
			   (warning form
				    "Too few arguments to procedure "
				    (variable-name proc))
			   #f)
		       (if (not (= (length (pexp->sexp (psd-cdr form)))
				   (variable-parameter-count proc)))
			   (warning form
				    "Wrong number of arguments to procedure "
				    (variable-name proc))))
		   #f)
	       (warning form "Procedure not defined: " (pexp->sexp (psd-car form))))))
	(else #f)))
         