#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Network Structure Queries

(declare (usual-integrations)
	 (integrate-external "struct"))

(define (what cell)
  (let (($equations
	 (lambda (shallow? separator)
	   ($print
	    (map (lambda (equation)
		   ($nested $nli ($literal (car equation))
			    separator ($literal (cadr equation))))
		 (tree-form cell shallow?))))))
    (if (not (node/bound? cell))
	(print $nl ($literal (cell/good-name cell))
	       " has no value.  I can express it this way:"
	       ($equations true " = "))
	(print $nl "The value "
	       ($literal (cell/value cell))
	       " in "
	       ($literal (cell/good-name cell))
	       " was computed in this way:"
	       ($equations false " <- "))))
  (print-forbidden-values (cell/true-supplier cell)))

(define (increment-cell/mark! cell)
  (set-cell/mark! cell
		  (if (eq? (cell/mark cell) 'UNMARKED)
		      'MARKED-ONCE
		      'MARKED-MANY)))

(define (tree-form cell shallow?)
  (increment-cell/mark! (cell/true-supplier cell))
  (tree-form/trace! cell shallow?)
  (let ((value (tree-form/gather cell shallow?)))
    (let loop ((cell cell))
      (let ((supplier (cell/true-supplier cell)))
	(if (not (eq? (cell/mark supplier) 'UNMARKED))
	    (begin
	      (set-cell/mark! supplier 'UNMARKED)
	      (let ((constraint (cell/owner supplier)))
		(if constraint
		    (for-each-vector-element (constraint/cells constraint)
					     loop)))))))
    value))

(define (tree-form/trace! cell shallow?)
  (if (node/bound? cell)
      (let ((supplier (cell/true-supplier cell)))
	(let ((constraint (cell/owner supplier)))
	  (cond ((not constraint)
		 (increment-cell/mark! supplier))
		((not shallow?)
		 (tree-form/trace-set!
		  (map (let ((cells (constraint/cells constraint)))
			 (lambda (input)
			   (vector-ref cells input)))
		       (rule/inputs (cell/rule supplier)))
		  false)))))
      (let ((cells (node/cells cell)))
	(usurper! (or (if shallow?
			  (or (tree-form/shallow cell cells)
			      (tree-form/deep cell cells true))
			  (or (tree-form/deep cell cells false)
			      (tree-form/shallow cell cells)))
		      (begin
			(if (cell/owner cell)
			    (tree-form/deep-trace! cell shallow?))
			cell))))))

(define (tree-form/deep-trace! cell shallow?)
  (tree-form/trace-set!
   (delq! cell (vector->list (constraint/cells (cell/owner cell))))
   shallow?))

(define (tree-form/trace-set! cells shallow?)
  (for-each (lambda (cell) (tree-form/trace! cell shallow?))
	    (list-transform-positive cells
	      (lambda (cell)
		(let ((supplier (cell/true-supplier cell)))
		  (increment-cell/mark! supplier)
		  (eq? (cell/mark supplier) 'MARKED-ONCE))))))

(define (tree-form/shallow cell cells)
  (list-search-positive cells
    (lambda (c)
      (and (not (eq? c cell))
	   (cell/global? c)))))

(define (tree-form/deep cell cells shallow?)
  (let loop ((cells cells) (default false))
    (if (null? cells)
	default
	(case (let ((constraint (cell/owner (car cells))))
		(if (or (eq? (car cells) cell) (not constraint))
		    'FORBIDDEN
		    (1d-table/get tree-form/preferences
				  (constraint/type constraint)
				  false)))
	  ((FORBIDDEN)
	   (loop (cdr cells) default))
	  ((DISLIKED)
	   (loop (cdr cells) (car cells)))
	  (else
	   (tree-form/deep-trace! (car cells) shallow?)
	   (car cells))))))

(define tree-form/preferences
  (make-1d-table))

(define *cuts*)
(define *all-cuts*)
(define *extra-equations*)

(define (tree-form/gather cell shallow?)
  (fluid-let ((*cuts* (list cell))
	      (*all-cuts* (list cell))
	      (*extra-equations* '()))
    (let loop ((equations '()))
      (if (null? *cuts*)
	  (reverse! (append *extra-equations* equations))
	  (let ((cut (car *cuts*)))
	    (set! *cuts* (cdr *cuts*))
	    (loop (cons (list (cell/good-name cut)
			      (tree-form/chase cut shallow? true))
			equations)))))))

(define (tree-form/chase cell shallow? top?)
  (if (and shallow? (node/bound? cell))
      (cell/value cell)
      (let ((supplier (cell/true-supplier cell)))
	(cond ((not (or top? (eq? (cell/mark supplier) 'MARKED-ONCE)))
	       (let ((global
		      (list-search-positive (node/cells supplier)
			(lambda (cell)
			  (good-global? cell supplier)))))
		 (cond ((or (cell/owner supplier) (not (cell/rule supplier)))
			(let ((best (or global supplier)))
			  (if (and (not (and (eq? best supplier)
					     (cell/global? best)))
				   (not (memq best *all-cuts*)))
			      (begin
				(set! *cuts* (cons best *cuts*))
				(set! *all-cuts* (cons best *all-cuts*))))
			  (cell/good-name best)))
		       ((not global)
			(cell/contents supplier))
		       (else
			(if (not (memq global *all-cuts*))
			    (begin
			      (set! *all-cuts* (cons global *all-cuts*))
			      (set! *extra-equations*
				    (cons (list (cell/name global)
						(cell/contents supplier))
					  *extra-equations*))))
			(cell/name global)))))
	      ((cell/owner supplier)
	       =>
	       (lambda (constraint)
		 (if (and (eq? supplier cell) (not top?))
		     (cell/good-name supplier)
		     (cons
		      (constraint-type/symbol (constraint/type constraint))
		      (append!
		       (map (lambda (cell)
			      (cond ((eq? cell supplier)
				     '%)
				    ((and
				      (node/bound? supplier)
				      (not
				       (memv (cell/name cell)
					     (rule/inputs
					      (cell/rule supplier)))))
				     '?)
				    (else
				     (tree-form/chase cell shallow? false))))
			    (let ((cells
				   (vector->list
				    (constraint/cells constraint))))
			      (if (and (not (null? cells))
				       (eq? (car cells) supplier))
				  (cdr cells)
				  cells)))
		       (let ((info (constraint/info constraint)))
			 (if info
			     (list info)
			     '())))))))
	      ((cell/global? supplier)
	       (cell/name supplier))
	      (else
	       (cell/contents supplier))))))

(define (good-global? cell supplier)
  (and (not (eq? cell supplier))
       (cell/global? cell)
       (case (cell/state cell)
	 ((SLAVE)
	  (memq (cell/state supplier) '(KING PUPPET SLAVE FRIEND)))
	 ((DUPE)
	  (case (cell/state supplier)
	    ((REBEL) (eq? (cell/contents cell) supplier))
	    ((DUPE) (eq? (cell/contents cell) (cell/contents supplier)))
	    (else false)))
	 (else
	  false))))