#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Utilities

(declare (usual-integrations))

(define (unionq x y)
  (if (null? y)
      x
      (let loop ((x x) (y y))
	(if (null? x)
	    y
	    (loop (cdr x)
		  (if (memq (car x) y)
		      y
		      (cons (car x) y)))))))

(define (subsetv? x y)
  (let loop ((x x))
    (or (null? x)
	(and (memv (car x) y)
	     (loop (cdr x))))))

(define (strict-subsetv? x y)
  (and (not (null? y))
       (let loop ((x x) (y (list-copy y)))
	 (or (null? x)
	     (let ((element (car x)))
	       (if (eqv? element (car y))
		   (and (not (null? (cdr y)))
			(loop (cdr x) (cdr y)))
		   (let delv-loop ((holder y) (scan (cdr y)))
		     (and (not (null? scan))
			  (if (eqv? element (car scan))
			      (begin
				(set-cdr! holder (cdr scan))
				(loop (cdr x) y))
			      (delv-loop scan (cdr scan)))))))))))

(define (list-remove-duplicates items equal? selector)
  (let loop ((items items))
    (if (null? items)
	'()
	(let ((rest (loop (cdr items))))
	  (if (there-exists? rest
		(let ((selection (selector (car items))))
		  (lambda (item)
		    (equal? selection (selector item)))))
	      rest
	      (cons (car items) rest))))))

(define (for-each-index limit procedure)
  (let loop ((i 0))
    (if (< i limit)
	(begin
	  (procedure i)
	  (loop (1+ i))))))

(define (for-each-vector-element vector procedure)
  (for-each-index (vector-length vector)
		  (lambda (i) (procedure (vector-ref vector i)))))

(define (y-or-n? . strings)
  (define (loop)
    (let ((char (char-upcase (read-char))))
      (cond ((or (char=? char #\Y)
		 (char=? char #\Space))
	     (write-string "Yes")
	     true)
	    ((or (char=? char #\N)
		 (char=? char #\Rubout))
	     (write-string "No")
	     false)
	    (else
	     (if (not (char=? char #\newline))
		 (beep))
	     (loop)))))
  (newline)
  (for-each write-string strings)
  (loop))