#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; KWH's Printer

(declare (usual-integrations))

(define (print . objects)
  (for-each (lambda (object)
	      (cond ((char? object) (write-char object))
		    ((string? object) (write-string object))
		    ((printer? object) (printer-apply object))
		    (else (write object))))
	    objects))

(define (printer? object)
  (and (pair? object)
       (eq? (car object) printer-tag)))

(define-integrable (printer-apply object)
  ((cdr object)))

(define-integrable (make-printer thunk)
  (cons printer-tag thunk))

(define printer-tag
  "printer")

(define (print-to-string . objects)
  (with-output-to-string
    (lambda ()
      (apply print objects))))

(define $nl (make-printer (lambda () (newline) (write-string ";"))))
(define ($literal object) (make-printer (lambda () (write object))))
(define ($nested . args) (make-printer (lambda () (apply print args))))
(define ($print args) (make-printer (lambda () (apply print args))))

(define ($pluralize word count)
  (if (= count 1)
      ($nested word)
      ($nested word "s")))

(define ($comma-separate items)
  ($separate items ", "))

(define ($separate items separator)
  ($print
   (let loop ((items items))
     (cons (car items)
	   (if (null? (cdr items))
	       '()
	       (cons separator (loop (cdr items))))))))

(define ($map prefix separator suffix procedure items)
  (if (null? items)
      ""
      ($nested prefix
	       ($print
		(let loop ((items items))
		  (cons (procedure (car items))
			(if (null? (cdr items))
			    '()
			    (cons separator (loop (cdr items)))))))
	       suffix)))

(define $nli
  ($nested $nl "   "))

(define (ctrace . objects)
  (if *ctrace?*
      (apply print $nl "|" objects)))

(define *ctrace?*
  false)

(define $nl-ctrace
  ($nested $nl "|   "))