#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Primitive Constraints

(declare (usual-integrations)
	 (integrate-external "struct"))

(define-macro (define-primitive name pins . rules)
  (let ((name (if (pair? name) (car name) name))
	(symbol (if (pair? name) (cadr name) name)))
    `(BEGIN
       (DEFINE ,name (MAKE-CONSTRAINT-TYPE ',name ',symbol ',pins))
       ,@(let loop ((rules rules) (id-bit 1))
	   (if (null? rules)
	       '()
	       (cons
		(let ((rule (car rules)))
		  (case (length rule)
		    ((2)
		     `(DEFINE-RULE ,name ',(car rule) #F #F ,id-bit
			(LAMBDA (*ME* *OUTVAR* ,@(car rule))
			  *ME* *OUTVAR*
			  ,(cadr rule))))
		    ((3)
		     `(DEFINE-RULE ,name ',(cadr rule)
			',(if (pair? (car rule)) (caar rule) (car rule))
			',(if (pair? (car rule)) (cadar rule) #F)
			,id-bit
			(LAMBDA (*ME* *OUTVAR* ,@(cadr rule))
			  *ME* *OUTVAR*
			  ,(caddr rule))))
		    (else
		     (error "Illegal rule clause" rule))))
		(loop (cdr rules) (* 2 id-bit))))))))

;;; These three primitives are not specific to the ground set of values.

(define-primitive (assumption assume) (pin)
  ((pin nogoodbeg)
   ()
   (let ((info (constraint/info *me*)))
     (if (forbidden? *outvar* info) rule-result:dismiss info))))

(1d-table/put! tree-form/preferences assumption 'DISLIKED)

(define-primitive oneof (pin)
  ((pin nogoodbeg) () (choose-from *outvar* (constraint/info *me*)))
  ((pin)
   (if (there-exists? (constraint/info *me*)
	 (lambda (value) (value=? value pin)))
       rule-result:dismiss
       rule-result:contradiction)))

(1d-table/put! tree-form/preferences oneof 'DISLIKED)

(define-primitive firstoneof (pin)
  ((pin nogood) () (choose-from *outvar* (constraint/info *me*))))

(1d-table/put! tree-form/preferences firstoneof 'DISLIKED)

(define value? integer?)
(define value=? =)
(define value<? <)

(define-primitive (adder +) (sum a b)
  (sum (a b) (+ a b))
  (b (sum a) (- sum a))
  (a (sum b) (- sum b)))

(define-primitive (multiplier *) (product a b)
  (product (a) (if (zero? a) 0 rule-result:dismiss))
  (product (b) (if (zero? b) 0 rule-result:dismiss))
  (product (a b) (* a b))
  (b (a product)
     (if (and (not (zero? a))
	      (zero? (remainder product a)))
	 (quotient product a)
	 rule-result:dismiss))
  (a (b product)
     (if (and (not (zero? b))
	      (zero? (remainder product b)))
	 (quotient product b)
	 rule-result:dismiss)))

(define-primitive (maxer max) (c a b)
  (c (a b) (max a b))
  (b (a c)
     (cond ((< a c) c)
	   ((> a c) rule-result:contradiction)
	   (else rule-result:dismiss)))
  (a (b c)
     (cond ((< b c) c)
	   ((> b c) rule-result:contradiction)
	   (else rule-result:dismiss))))

(define-primitive (minner min) (c a b)
  (c (a b) (min a b))
  (b (a c)
     (cond ((> a c) c)
	   ((< a c) rule-result:contradiction)
	   (else rule-result:dismiss)))
  (a (b c)
     (cond ((> b c) c)
	   ((< b c) rule-result:contradiction)
	   (else rule-result:dismiss))))

(define-primitive (equality =) (p a b)
  ((p)
   (if (or (zero? p) (= p 1))
       rule-result:dismiss
       rule-result:contradiction))
  ((p nogoodbeg) () (resolve-among *outvar* '(0 1)))
  (p (a b) (if (= a b) 1 0))
  (b (a p) (if (= p 1) a rule-result:dismiss))
  (a (b p) (if (= p 1) b rule-result:dismiss)))