======================================================================
;;; struct.scm: Macros for scm4 implement RECORDS from the book:
;;; "Essentials of Programming Languages" by Daniel P. Friedman,
;;;   M. Wand and C.T. Haynes.
;;; Copyright 1992 Jeff Alexander, Shinnder Lee, and Lewis Patterson

;;; jaffer@ai.mit.edu, Feb 1993 polished code for SCM.

(require 'common-list-functions)	;only one used is EVERY

(define struct:gensym
  (let ((gensymnum -1))
    (lambda ()
      (set! gensymnum (+ gensymnum 1))
      (string->symbol (string-append "sG" (number->string gensymnum))))))

(define define-record
  (procedure->memoizing-macro
    (let* ((vec-sym (struct:gensym)))
      (lambda (args env)
	(check-define-record-syntax args
	  (lambda (name make-name name? field-accessors)
	    (letrec
	      ((make-fields
		 (lambda (field-accessors i)
		   (if (null? field-accessors)
		     '()
		     (cons
		       `(define ,(car field-accessors)
			  (lambda (obj)
			    (if (,name? obj)
			      (vector-ref obj ,i)
			      (error ',(car field-accessors)
				": bad record" obj))))
		       (make-fields (cdr field-accessors) (+ i 1)))))))
	      `(begin
		 ,@(make-fields field-accessors 1)
		 (define ,name?
		   (lambda (obj)
		     (and (vector? obj)
		       (= (vector-length obj) ,(+ 1 (length field-accessors)))
		       (eq? (vector-ref obj 0) ',name))))
		 (define ,make-name
		   (let ((,vec-sym vector))
		     (lambda ,field-accessors
		       (,vec-sym ',name ,@field-accessors))))))))))))

(define variant-case
  (procedure->memoizing-macro
    (lambda (args env)
      (check-variant-case-syntax args
	(lambda (exp clauses)
	  (let ((var (struct:gensym)))
	    (let
	      ((make-clause
		 (lambda (clause)
		   (if (eq? (car clause) 'else)
		     `(#t ,@(cdr clause))
		     `((,(car clause) ,var)
		       (let ,(map (lambda (field)
				    `(,(car field) (,(cdr field) ,var)))
			       (cadr clause))
			 ,@(cddr clause)))))))
	      `(let ((,var ,exp))
		 (cond ,@(map make-clause clauses))))))))))

;;; syntax checkers

;;; name make-name name? field-accessors

(define check-define-record-syntax
  (lambda (x k)
      (cond
	((and (list? x)
	   (= (length x) 3)
	   (symbol? (cadr x))
	   (list? (caddr x))
	   (every symbol? (caddr x))
	   (not (duplicate-fields? (caddr x))))
	 (let ((name (symbol->string (cadr x))))
	   (let ((make-name (string->symbol
			      (string-append (symbol->string 'make-) name)))
		 (name? (string->symbol (string-append name "?")))
		 (field-accessors
		   (map
		     (lambda (field)
		       (string->symbol
			 (string-append name "->" (symbol->string field))))
		     (caddr x))))
	     (k (cadr x) make-name name? field-accessors))))
	(else (error "define-record: invalid syntax" x)))))
       
(define check-variant-case-syntax
  (let
    ((make-clause
       (lambda (clause)
	 (if (eq? (car clause) 'else) 
	   clause
	   (let ((name (symbol->string (car clause))))
	     (let ((name? (string->symbol (string-append name "?")))
		   (fields
		     (map
		       (lambda (field)
			 (cons field
			   (string->symbol
			     (string-append name "->"
			       (symbol->string field)))))
		       (cadr clause))))
	       (cons name? (cons fields (cddr clause)))))))))
    (lambda (args k)
      (if (and (list? args)
	    (<= 3 (length args))
	    (struct:clauses? (cddr args)))
	(k (cadr args) (map make-clause (cddr args)))
	(error "variant-case: invalid syntax" args)))))

(define duplicate-fields?
  (lambda (fields)
    (cond
      ((null? fields) #f)
      ((memq (car fields) (cdr fields)) #t)
      (else (duplicate-fields? (cdr fields))))))

(define struct:clauses?
  (let
    ((clause?
       (lambda (clause)
	 (and (list? clause)
	      (not (null? clause))
	      (cond
		((eq? (car clause) 'else)
		 (not (null? (cdr clause))))
		(else (and (symbol? (car clause))
			   (not (null? (cdr clause)))
			   (list? (cadr clause))
			   (every symbol? (cadr clause))
			   (not (duplicate-fields? (cadr clause)))
			   (not (null? (cddr clause))))))))))
    (letrec
      ((duplicate-tags?
	 (lambda (tags)
	   (cond
	     ((null? tags) #f)
	     ((eq? (car tags) 'else) (not (null? (cdr tags))))
	     ((memq (car tags) (cdr tags)) #t)
	     (else (duplicate-tags? (cdr tags)))))))
      (lambda (clauses)
	(and (every clause? clauses)
	     (not (duplicate-tags? (map car clauses))))))))

;(define-record foo (a b c))
;(define-record goo (xx yy))

;(define a-foo (make-foo 1 2 3))
;(define a-goo (make-goo 4 5))

;(define (struct:test)
;  (define (t1 x)
;    (variant-case x
;      (foo (a b c) (list a b c))
;      (goo (xx yy) (list xx yy))
;      (else (list 7 8))))
;  (write (append (t1 a-foo) (t1 a-goo) (t1 9)))
;  (newline))


