= (MakeTriple '(1 2 3 4 5) 'invalid)
  #(invalid NEG-INFINITY (1 2 3 4 5))

= (MakeTriple '(1 2 3 4 5) 'ok)
  #(ok NEG-INFINITY (1 2 3 4 5))
                         
= (GetTripleStatus '#(ok 123 (1 2 3 4 5)))
  ok

= (SetTripleStatus! '#(ok 123 (1 2 3 4 5)) 'illegal)
  #(illegal 123 (1 2 3 4 5))

= (ValidTripleState? '#(ok 123 (1 2 3 4 5)))
  #t

= (ValidTripleState? '#(illegal 123 (1 2 3 4 5)))
  #f
                               
= (InvalidTripleState? '#(ok 123 (1 2 3 4 5)))
  #f

= (InvalidTripleState? '#(illegal NEG-INFINITY (1 2 3 4 5)))
  #t
                               
= (GetTripleValue '#(ok -9999 (1 2 3 4 5)))
  -9999

= (GetTripleValue '#(ok 123 (1 2 3)))
  123

= (GetTripleValue '#(notok 123 (1 2 3)))
  NEG-INFINITY

= (SetTripleValue! '#(ok 123 (1 2 3)) 345)
  #(ok 345 (1 2 3))

! (define testEvalFN* #f)
  
= (ScoreTripleValue! '#(ok -9999 (1 2 3)) testEvalFN*)
  NEG-INFINITY

! (define testEvalFN* (lambda (aState) 123))
  
= (ScoreTripleValue! '#(ok NEG-INFINITY (1 2 3)) testEvalFN*)
  123

= (GetTripleState '#(ok 123 (1 2 3)))
  (1 2 3)
  
= (EmptyTriple? '#(ok 123 (1 2 3)))
  #f
  
= (EmptyTriple? ())
  #t
 
! (define testGoalFN* (lambda (aState) #t))
! (define searchProblem* (MakeSearchProblem '(1 2 3)
                             testGoalFN*
                             testEvalFN*
                             ()))

; this action routine adds one to the first element of the state
! (define xxx (lambda (s) (cons (+ (car s) 1) (cdr s))))
  

= (RestOfActions (MakeActionList xxx))
  ()
  
= (EmptyActions? (MakeActionList xxx))
  #f
  
= (EmptyActions? ())
  #t

! (define searchProblem* (MakeSearchProblem '(1 2 3)
                             testGoalFN*
                             testEvalFN*
                             (MakeActionList xxx)))
    
= (ExploreAll '#(ok 123 (1 2 3)) searchProblem*)
  (#(ok NEG-INFINITY (2 2 3)))
    
! (define searchProblem* (MakeSearchProblem '(1 2 3)
                             testGoalFN*
                             testEvalFN*
                             (MakeActionList xxx xxx)))
    
= (ExploreAll '#(ok 123 (1 2 3)) searchProblem*)
  (#(ok NEG-INFINITY (2 2 3))
   #(ok NEG-INFINITY (2 2 3)))
  