
; test of production system toolbox

! (define *WM*
        (MakeWM '(wolfgang is male)
                '(wolfgang is secretive)
                '(this fact should go)
                '(wolfgang is old)))

! (define myProc
    (lambda (aWM)
      (list 'EXIT-VALUE aWM)))
  
! (define *PM*
        (MakePM (RULE 'rule1
                      (CONDITIONS
                       (PATTERN (? 'x) 'is 'male)
                       (PATTERN (<-? 'x) 'is 'old))
                      (CONCLUSIONS
                       (ASSERT (PATTERN (<-? 'x) 'is 'widower))
                       (RETRACT '(this fact should go))
                       (EXECUTE
                        DisplayLine "added widower"
                                    (PATTERN (<-? 'x)))))
                (RULE 'rule2
                      (CONDITIONS
                       (~ (PATTERN ? 'is 'thin)))
                      (CONCLUSIONS
                       (EXECUTE
                        DisplayLine "missing size")))
                (RULE 'rule3
                      (CONDITIONS
                       (PATTERN (? 'x) 'is 'male)
                       (PATTERN (<-? 'x) 'is 'secretive))
                      (CONCLUSIONS
                       (EXECUTE
                        DisplayLine "watch out for"
                                    (PATTERN (<-? 'x)))
                       (RETURN myProc)))))
  
? (ForwardChainer *PM* *WM*)
  (list 'EXIT-VALUE
        (MakeWM '(wolfgang is male)
                '(wolfgang is secretive)
                '(wolfgang is old)
                '(wolfgang is widower)))

! (define oneRule
    (RULE 'rule1
          (CONDITIONS
           (PATTERN (? 'x) 'is 'male)
           (PATTERN (<-? 'x) 'is 'old))
          (CONCLUSIONS
           (ASSERT (PATTERN (<-? 'x) 'is 'widower))
           (RETRACT '(this fact should go))
           (EXECUTE (lambda (string nameInList)
                      (DisplayLine string (car nameInList)))
                    "handling widower"
                    (PATTERN (<-? 'x))))))

! (set! *WM*
        (MakeWM '(wolfgang is male)
                '(wolfgang is secretive)
                '(bruce is male)
                '(bruce is young)
                '(this fact should go)
                '(wolfgang is old)))

= (FireRule oneRule *WM*)
  ((wolfgang is male)
   (wolfgang is secretive)
   (bruce is male)
   (bruce is young)
   (wolfgang is old)
   (wolfgang is widower))
  
; tests from section 3.4.2 of book
  
!	(define RiverWorld 
    (MakeWM '(friends bear tiger) 
            '(friends bear mole))) 

!	(PrintWM RiverWorld)

!	(define RespectRule
    (RULE 'friendshipImpliesRespect 
          (CONDITIONS  
           (PATTERN 'friends (? 'x) (? 'y)))
          (CONCLUSIONS 
           (ASSERT (PATTERN 'respects 
                            (<-? 'x) 
                            (<-? 'y)))) ))

!	(PrintRule RespectRule)

!	(define QuarrelRule
    (RULE 'breakFriendship 
          (CONDITIONS  
           (PATTERN 'quarrels (? 'x) (? 'y)))
          (CONCLUSIONS 
           (RETRACT 
            (PATTERN 'friends (<-? 'x) (<-? 'y))) 
           (RETRACT 
            (PATTERN 'friends (<-? 'y) (<-? 'x))) 		    
           )))

!	(define Deductions 
    (MakePM RespectRule QuarrelRule))

!	(PrintPM Deductions)

!	(set! RiverWorld 
        (ForwardChainer Deductions RiverWorld #t))
 
= RiverWorld
  ((friends bear tiger) (friends bear mole) 
	  (respects bear tiger) (respects bear mole))

!	(set! RiverWorld 
        (AddFact RiverWorld 
                 (PATTERN 'quarrels 'bear 'mole)))
= RiverWorld
  ((friends bear tiger) (friends bear mole) 
   (respects bear tiger) (respects bear mole) 
   (quarrels bear mole))
  
!	(set! RiverWorld 
        (ForwardChainer Deductions RiverWorld #t))

= RiverWorld
	 ((friends bear tiger) (respects bear tiger)
   (respects bear mole) (quarrels bear mole))

!	(PrintWM RiverWorld)

!	(define LikesRule 
    (RULE 'likes 
          (CONDITIONS 
           (PATTERN 'respects (? 'x) (? 'y))
           (~ (PATTERN 'quarrels 
                       (<-? 'x) (<-? 'y))))
          (CONCLUSIONS 
           (EXECUTE 
            (lambda (message)
              (DisplayLine message))
            (PATTERN (<-? 'x) "likes" (<-? 'y))))))

!	(set! Deductions (AddFact Deductions LikesRule))
 
!	(PrintRule LikesRule)

=	(FireRule LikesRule RiverWorld)
	 ((friends bear tiger) (respects bear tiger) 
	  (respects bear mole) (quarrels bear mole)) 

