! (define isxnumber?
    (lambda (aList)
      (number? (GetAssociationValue 'x aList))))
  
! (define isxodd?
    (lambda (aList)
      (odd? (GetAssociationValue 'x aList))))
  
! (define isxeven?
    (lambda (aList)
      (even? (GetAssociationValue 'x aList))))
  
! (define myKB (MakeKB '(FACT1 1) '(FACT2 2) '(FACT3 3) '(FACT4 4)))

= (RetrieveByPattern myKB (PATTERN ? 1))
  ((FACT1 1) #t)

= (RetrieveByPattern myKB (PATTERN ? 1) (lambda (x) x))
  ((FACT1 1) #t)
  
= (RetrieveByPattern myKB (PATTERN ? 1) (lambda (x) x) #f)
  ((FACT1 1) #t)
  
= (RetrieveByPattern myKB (PATTERN ? 1) #f (lambda (x) x))
  ((FACT1 1) #t)
  
= (RetrieveByPattern myKB (PATTERN ? 1) #f)
  ((FACT1 1) #t)
  
! (set! myKB (AddFact myKB '(FACT5 0)))

= (RetrieveByPattern myKB (PATTERN ? 0))
  ((FACT5 0) #t)

! (set! myKB (RemoveFact myKB '(FACT1 1)))

= (RetrieveByPattern myKB (PATTERN ? 1))
  #f

= (RetrieveByPattern myKB (PATTERN (? 'x isxnumber? isxodd?))
                          (lambda (x) (list (cadr x))))
  ((FACT3 3) ((x 3)))

= (RetrieveByPattern myKB (PATTERN (<-? 'x))
                          (lambda (x) (list (cadr x)))
                          '((x 3)))
  ((FACT3 3) ((x 3)))

= (RetrieveAllByPattern myKB (PATTERN (? 'x isxnumber? isxeven?))
                             (lambda (x) (list (cadr x))))
  (((FACT2 2) ((x 2))) ((FACT4 4) ((x 4))) ((FACT5 0) ((x 0))))

! (define makeMyFact
    (lambda (aPattern aValue) (list aPattern aValue)))
! (define myPatternKB (MakeKB (makeMyFact (PATTERN "FACT1") 1)
                            (makeMyFact (PATTERN "FACT2") 2)
                            (makeMyFact (PATTERN (? 'fact)) 999)))

= (RetrieveByString myPatternKB '("FACT1") car)
  ((("FACT1") 1) #t)

= (RetrieveByString myPatternKB '("FACT2") car)
  ((("FACT2") 2) #t)

? (RetrieveByString myPatternKB '("FACT3") car)
  (MakeRetrievedElement (makeMyFact (PATTERN (? 'fact)) 999)
                        '((fact "FACT3")))

? (RetrieveAllByString myPatternKB '("FACT1") car)
  (list '((("FACT1") 1) #t)
        (MakeRetrievedElement (makeMyFact (PATTERN (? 'fact)) 999)
                        '((fact "FACT1"))))


; tests from section 3.3.3 of book

!	(define RiverWorld 
    (MakeKB '(little bear)
            '(little tiger)
            '(big    tiger)
            '(happy  mole)))

!	(define whoIs 
    (lambda (aWorld aProperty) 
      (map (lambda (anElement)
             (cadr (GetFact anElement)))
           (retrieveAllBypattern 
            aWorld 
            (PATTERN aProperty ?)) )))

=	(whoIs RiverWorld 'little)
  (bear tiger)

!	(define OwlsMemory 
    (MakeKB 
     (PATTERN ?+ 'little (? 'smallOne) ?+)
     (PATTERN ?+ 'brave  (? 'braveONe) ?+)
     (PATTERN ?+ 'happy  (? 'happyOne) ?+)))

?	(RetrieveAllByString 
   OwlsMemory 
   '(there is little bear 
     who is also a brave bear
     and then there is happy mole of course))
  (list (list (PATTERN ?+ 'little (? 'smallOne) ?+) 
              '((smallone bear))) 
        (list (PATTERN ?+ 'brave  (? 'braveONe) ?+) 
              '((braveone bear))) 
        (list (PATTERN ?+ 'happy  (? 'happyOne) ?+) 
              '((happyone mole))))
  
!	(define OwlsMemory 
    (MakeKB 
     (cons (PATTERN ?+ 'little (? 'x) ?+)
           ; a procedure 
           (lambda (aFriend)
             (DisplayLine "I'm little"
                          aFriend)))
     (cons (PATTERN ?+ 'hasty  (? 'x) ?+) 
           ; a procedure
           (lambda (aFriend)
             (DisplayLine "I'm hasty" 			
                          aFriend)))
     (cons (PATTERN ?+ 'lazy   (? 'x) ?+) 
           ; a procedure
           (lambda (aFriend)
             (DisplayLine "I'm lazy" 			
                          aFriend))) ))

!	(define element 
    (RetrieveByString
     ; the knowledge base 
     OwlsMemory
     ; the "string" (a list !) 
     '(there little bear who is also a brave bear 	
      and there is happy mole of course)
     ; and the selection procedure
     car))

=	(GetAList element)
  ((x bear))

?	(GetFact element)
  (cons ; this is the "successful" pattern
   (PATTERN ?+ 'little (? 'x) ?+)
   ; and this is the associated procedure 
   (lambda (aFriend)
     (DisplayLine "I'm little"
                  aFriend)))
  
!	( ; apply the procedure
   (cdr (GetFact element))
   ; to the AList binding for 'x 
   (GetAssociationValue 'x (GetAlist element)))
  