; test of Frames toolbox

! (define proc #f)
  
! (define AskForHelp
    (lambda (anFN frameName slotName)
      ; Supplies the race of a muppet
      (DisplayLine "AskForHelp is supplying value for"
                   slotName
                   "of"
                   frameName)
      (set! proc 'AskForHelp)
      'Mongolian))
      
! (define Jubilate
    (lambda (anFN frameName slotName aValue)
      (set! proc 'Jubilate)
      (if (equal? aValue '(MissPiggy))
          (begin
           (DisplayLine "There is no way I want"
                        aValue
                        "as a hobby")
           #f)
          (begin
           (DisplayLine "Hosianna, I now have a new hobby"
                        aValue)
           anFN))))
  
! (define HaveAFit
    (lambda (anFN frameName slotName aValue)
      (set! proc 'HaveAFit)
      (if (equal? aValue '(Kermit))
          (begin
           (DisplayLine "There is no way I will let"
                        aValue
                        "go as a hobby")
           #f)
          (begin
           (DisplayLine "Aaaarrrrggghhhh!, Give me back my hobby "
                        aValue)
           anFN))))

! (define MuppetWorld
    (MakeFN
     (FRAME 'Muppet (SLOT 'Race (IF-NEEDED AskForHelp)))
     (FRAME 'Frog   (AKO 'Muppet)
                    (SLOT 'Colour (DEFAULT 'Green)))
     (FRAME 'Kermit (AKO 'Frog)
                    (SLOT 'Hobbies (VALUE '(Flies Stamps))
                                   (IF-ADDED Jubilate))
                    (SLOT 'Mood (VALUE 'Chirpy)))
     (FRAME 'MissPiggy   (AKO 'Muppet)
                         (SLOT 'Hobbies (VALUE '(Kermit))
                                        (IF-REMOVED HaveAFit))
                         (SLOT 'Mood (DEFAULT 'Lousy)))
     (FRAME 'Skooter     (AKO 'Muppet)
                         (SLOT 'Hobbies (VALUE '(Henrietta)))
                         (SLOT 'Weight  (VALUE 'High)))))
  
= (FindFrame MuppetWorld 'Skooter)
  (Skooter ((AKO (Muppet))
            (Hobbies ((VALUE (Henrietta))))
            (Weight  ((VALUE High)))))
  
= (FindSlot (FindFrame MuppetWorld 'Skooter) 'Hobbies)
  (Hobbies ((VALUE (Henrietta))))

= (FindSlot (FindFrame MuppetWorld 'Skooter) 'Hobby)
  #f

= (FindFacet (FindSlot (FindFrame MuppetWorld 'Skooter) 'Hobbies) 'VALUE)
  (VALUE (Henrietta))

= (FindFacet (FindSlot (FindFrame MuppetWorld 'Skooter) 'Hobbies) 'DEFAULT)
  #f

= (GetAKOChain MuppetWorld 'Kermit)
  (Kermit Frog Muppet)
  
= (FindFrame (RemoveFacet MuppetWorld 'Skooter 'Hobbies 'VALUE)
             'Skooter)
  (Skooter ((AKO (Muppet))
            (Weight  ((VALUE High)))
            (Hobbies ())))
  
= (FindFrame (RemoveFacet MuppetWorld 'Skooter 'Hobbies 'DEFAULT)
             'Skooter)
  (Skooter ((AKO (Muppet))
            (Hobbies ((VALUE (Henrietta))))
            (Weight  ((VALUE High)))))
  
? (FindSlot (FindFrame MuppetWorld 'Kermit) 'Hobbies)
  (SLOT 'Hobbies (VALUE '(Flies Stamps))
                 (IF-ADDED Jubilate))
  
! (define MuppetWorld2
        (AddFacet MuppetWorld 'Kermit 'Hobbies (VALUE '(Pigs))))

= proc
  Jubilate

? (FindSlot (FindFrame MuppetWorld2 'Kermit) 'Hobbies)
  (SLOT 'Hobbies (IF-ADDED Jubilate)
                 (VALUE '(Pigs)))
  
! (set! MuppetWorld2
        (AddFacet MuppetWorld 'Kermit 'Hobbies (VALUE '(MissPiggy))))

? (FindSlot (FindFrame MuppetWorld2 'Kermit) 'Hobbies)
  (SLOT 'Hobbies (IF-ADDED Jubilate))

? (FindSlot (FindFrame MuppetWorld 'MissPiggy) 'Hobbies)
  (SLOT 'Hobbies (VALUE '(Kermit))
                 (IF-REMOVED HaveAFit))
  
! (set! MuppetWorld2
        (RemoveFacet MuppetWorld 'MissPiggy 'Hobbies 'VALUE))

= proc
  HaveAFit

? (FindSlot (FindFrame MuppetWorld2 'MissPiggy) 'Hobbies)
  (SLOT 'Hobbies (VALUE '(Kermit))
                 (IF-REMOVED HaveAFit))

! (AddAValue MuppetWorld 'Kermit 'Hobbies '(Pigs))

= proc
  Jubilate

! (RemoveAValue MuppetWorld 'MissPiggy 'Hobbies)

= proc
  HaveAFit

= (GetAValue MuppetWorld 'Kermit 'Hobbies)
  (Flies Stamps)
  
= (GetAValue MuppetWorld 'Kermit 'Colour)
  Green

= (GetAValue MuppetWorld 'Kermit 'Race)
  Mongolian

; tests from section 3.6.2 of book

!	(define Habitat
    (MakeFN
     (FRAME 'Creature (SLOT 'wings (DEFAULT 'none)))
     (FRAME 'Elephant (AKO 'Creature)
                      (SLOT 'legs   (DEFAULT 4))
                      (SLOT 'colour (DEFAULT 'grey))
                      (SLOT 'race   (VALUE 'mammal)))
     (FRAME 'clyde	(AKO 'Elephant)
                   (SLOT 'livesIn   (VALUE 'zoo))
                   (SLOT 'colour    (VALUE 'pink))
                   (SLOT 'birthYear (VALUE 1946)))     
     ))

!	(PrintFN Habitat)

=	(FindAllFrameNames Habitat)
	 (creature elephant clyde)                                                                       

= (FindAllSlotNames Habitat)
	 (birthyear livesin race colour legs wings)

= (FindFrame Habitat 'clyde)
	 (clyde ((ako (elephant))
          (livesin ((value zoo)))
          (colour ((value pink)))
          (birthyear ((value 1946)))))


= (FindSlot (FindFrame Habitat 'clyde) 'colour)
	 (colour ((value pink)))

= (GetAKOSlot Habitat 'clyde)
	 (ako (elephant))
    
=	(GetAKOLinks Habitat 'clyde)
	 (elephant)
    
=	(GetAkoChain Habitat 'clyde)
	 (clyde elephant creature)

=	(GetAValue Habitat 'clyde 'colour)
	 pink

=	(GetAValue Habitat 'clyde 'politicalPersuasion)
	 "NOTKNOWN"

! (AddAValue Habitat 'clyde 'colour 'striped)
	 ; ((creature ... (livesin ((value zoo))) 
	 ;  (colour ((value striped))))))

!	(set! Habitat 
        (RemoveAValue Habitat 'clyde 'colour))
  ; ((creature ... ((value zoo))) (colour ()))))
    
=	(GetAValue Habitat 'clyde 'colour)
  grey

!	(set! Habitat
        (AddFacet Habitat 'clyde 'colour 
                                 (IF-NEEDED 
                                  (lambda (aNetwork aFrame aSlot)
                                    ; IF-NEEDED demons always expect 3 parameters !
                                    (display "you tell me!")))))
  ; ((creature ... ((if-needed #<procedure> ))))))

!	(GetAValue Habitat 'clyde 'colour)
	 ; you tell me! #t

!	(set! Habitat 
        (RemoveFacet Habitat 'clyde 'colour 'IF-NEEDED))
      ; ((creature ... ((value zoo))) (colour ()))))

=	(GetAValue Habitat 'clyde 'colour)
	 grey

!	(set! Habitat 
        (AddFrame 
         Habitat 
         (FRAME 'Zoo      
                (SLOT 'location
                      (VALUE 
                       "out of town and down by the river"))
                (SLOT 'animals (VALUE '()))) ))
  ; ((creature ... (animals ((value ))))))))
       
=	(FindAllFrameNames Habitat)
	 (creature elephant clyde zoo)

!	(set! Habitat 
        (AddAValue Habitat 'zoo 'animals 
                                (cons 'clyde 
                                      (GetAValue 
                                       Habitat 'zoo 'animals))))
  ; (creature ... (animals ((value (clyde)))))))

= (GetAValue Habitat 'zoo 'animals)
	 (clyde)

!	(set! Habitat
        (AddSlot 
         Habitat
         'Creature 
         (SLOT 'age 
               (IF-NEEDED
                (lambda 
                  (aNetWork aFrameName aSlotName)
                  (let ((year 0))
                    (display 
                     "What year is it ? ")
                    (set! year (read)) 
                    (newline)
                    (- year 
                       (GetAValue 
                        aNetwork
                        aFrameName 	    
                        'birthYear)))))) ))
  ; (creature ... (age ((if-needed #<procedure> )))))))

! (DisplayLine "Supply 1988 as answer to next question")    
=	(GetAValue Habitat 'clyde 'age)
	 42

!	(set! Habitat
        (AddFacet
         Habitat
         'Creature
         'wings                 
         (IF-ADDED
          (lambda 
            (aNetwork aFrameName aSlotName aValue)
            (if (not (eq?
                      (GetAValue aNetwork 			
                                 aFrameName 				
                                 'race)
                      'bird))
                (begin
                 (DisplayLine 
                  "only birds may have wings !"
                  "since you're not a bird"
                  "you can't have" aValue) #f)
                aNetwork)) )))
  ; (creature ... 
  ;       (((default none) ((if-added #<procedure> ))))))

!	(AddAValue Habitat 'clyde 'wings 2)
	; only birds may have wings ! 
	; since you're not a bird you can't have 2
	; ((creature ... 
 ;        (((default none) ((if-added #<procedure> ))))))

!	(set! Habitat
        (AddFacet 
         Habitat
         'Zoo
         'animals 
         (IF-REMOVED
          (lambda
            (aNetwork aFrameName aSlotName aValue)
            ; make all animals homeless
            (for-each 
             (lambda (anAnimal)
               (set! aNetwork                            	
                     (AddAValue aNetwork 
                                anAnimal 
                                'livesIn 
                                'homeless)))
             aValue) 
            aNetwork)) ))
  ; ((creature ... 
  ;       ((value (clyde)) (if-removed #<procedure> ))))))

=	(GetAValue Habitat 'clyde 'livesIn)
	 zoo
        
!	(set! Habitat 
	      (RemoveAValue Habitat 'zoo 'animals))
	; ((creature ... 
 ;         (animals ((if-removed #<PROCEDURE>))))))
    
=	(GetAValue Habitat 'clyde 'livesIn)
	 homeless
