; test of AN toolbox

; first the non-fuzzy version of routines

! (define DyingEarth
    (MakeAN
     (CONCEPT 'Cugel (AKO 'StoryCharacter 'CleverAdventurer) 
                          (LINK 'Is 'Pretty))
     (CONCEPT 'Bunderwal (AKO 'StoryCharacter 'Adventurer))
     (CONCEPT 'Iucounu   (AKO 'StoryCharacter 'Magician))
     (CONCEPT 'Sadlark   (AKO 'StoryCharacter 'Monster))
     
     (CONCEPT 'Pretty)
     (CONCEPT 'StoryCharacter (LINK 'Is 'Imaginary)
                              (LINK 'LivesIn 'Book))
     (CONCEPT 'Imaginary) 
     (CONCEPT 'Book)
     
     (CONCEPT 'CleverAdventurer (AKO 'Adventurer) 
                                (LINK 'Has 'Wit)
                                (LINK 'Knows 'Tricks))
     (CONCEPT 'Wit) 
     (CONCEPT 'Tricks)
     
     (CONCEPT 'Adventurer (AKO 'Human)
                          (LINK 'Hates 'Danger)
                          (LINK 'Has 'Curiosity))
     (CONCEPT 'Curiosity (LINK 'Has 'Danger))
     (CONCEPT 'Danger)
     
     (CONCEPT 'Human (AKO 'Creature)
                     (LINK 'Is 'Mortal)
                     (LINK 'Has 'Dignity)
                     (LINK 'Likes 'Money))
     (CONCEPT 'Mortal) 
     (CONCEPT 'Dignity) 
     (CONCEPT 'Money)
     
     (CONCEPT 'Creature (LINK 'Has 'Life))
     (CONCEPT 'Life)
     
     (CONCEPT 'Magician (AKO 'Human)
                        (LINK 'Has 'Money)
                        (LINK 'Knows 'Spells)
                        (LINK 'Likes 'Power)
                        (LINK 'Likes 'PracticalJoke))
     (CONCEPT 'Spells) 
     (CONCEPT 'Power)
     (CONCEPT 'PracticalJoke)
     
     (CONCEPT 'Monster (AKO 'Creature)
                       (LINK 'Has 'BadBreath)
                       (LINK 'Owns 'Treasures)
                       (LINK 'Has 'Curiosity))
     (CONCEPT 'BadBreath)
     (CONCEPT 'Treasures)
     (CONCEPT 'SweetNature)))
  
= (FindConcept DyingEarth 'Cugel)
  (Cugel ((AKO (StoryCharacter CleverAdventurer))
          (Is Pretty)))

! (define newConcept (CONCEPT 'Fred (AKO 'Magician)
                                    (LINK 'Has 'LongLegs)))
  
? (FindConcept (AddConcept DyingEarth newConcept) 'Fred)
  newConcept

! (define newerConcept (CONCEPT 'Fred (AKO 'Magician)
                                      (LINK 'Has 'ShortLegs)))
  
? (FindConcept (AddConcept (AddConcept DyingEarth
                                       newConcept)
                           newerConcept) 'Fred)
  newerConcept

= (FindConcept (RemoveLink DyingEarth 'CleverAdventurer 'Has)
               'CleverAdventurer)
  (CleverAdventurer ((AKO (Adventurer))
                     (Knows Tricks)))

= (FindConcept (AddLink DyingEarth 'CleverAdventurer (LINK 'Has 'Legs))
               'CleverAdventurer)
  (CleverAdventurer ((AKO (Adventurer))
                     (Knows Tricks)
                     (Has Legs)))

= (FindConcept (AddLink DyingEarth 'CleverAdventurer (LINK 'Eats 'Cake))
               'CleverAdventurer)
  (CleverAdventurer ((AKO (Adventurer))
                     (Has Wit)
                     (Knows Tricks)
                     (Eats Cake)))
  
= (GetAKOLinks DyingEarth 'Bunderwal)
  (StoryCharacter Adventurer)
  
= (GetAKOLinks (RemoveAKOLink DyingEarth 'Bunderwal 'StoryCharacter)
               'Bunderwal)
  (Adventurer)

= (GetAKOLinks (AddAKOLink DyingEarth 'Bunderwal 'Magician)
               'Bunderwal)
  (StoryCharacter Adventurer Magician)

= (GetAKOLinks (AddAKOLink DyingEarth 'Bunderwal 'StoryCharacter)
               'Bunderwal)
  (StoryCharacter Adventurer)

= (GetAKOChain DyingEarth 'Cugel)
  (Cugel StoryCharacter CleverAdventurer Adventurer Human Creature)
  
= (FindAllLinkedConcepts DyingEarth 'Cugel 'Has)
  ((Has Wit) (Has Curiosity) (Has Dignity) (Has Danger) (Has Life))
  
= (FindAllLinkedConcepts DyingEarth 'Cugel 'Hates)
  ((Hates Danger))

= (FindAllLinkedConcepts DyingEarth 'Cugel 'Is)
  ((Is Pretty) (Is Imaginary) (Is Mortal))

= (FindAllLinks DyingEarth 'Cugel 'Mortal)
  ((Is Mortal))

= (FindAllLinks DyingEarth 'Cugel 'Danger)
  ((Hates Danger) (Has Danger))

= (FindAllLinks DyingEarth 'Cugel 'Creature)
  (AKO)

= (Linked? DyingEarth 'Cugel 'Danger)
  #t

= (Linked? DyingEarth 'Danger 'Cugel)
  #f

; Now the fuzzy versions 

! (define DyingEarth-Fuzzy
    (MakeAN
     (CONCEPT 'Cugel (AKO 'StoryCharacter 'CleverAdventurer) 
                     (LINK 'Is 'Pretty 0.5))
     (CONCEPT 'Bunderwal (AKO 'StoryCharacter 'Adventurer))
     (CONCEPT 'Iucounu   (AKO 'StoryCharacter 'Magician))
     (CONCEPT 'Sadlark   (AKO 'StoryCharacter 'Monster))
     
     (CONCEPT 'Pretty)
     (CONCEPT 'StoryCharacter (LINK 'Is 'Imaginary 0.5)
                              (LINK 'LivesIn 'Book))
     (CONCEPT 'Imaginary) 
     (CONCEPT 'Book)
     
     (CONCEPT 'CleverAdventurer (AKO 'Adventurer) 
                                (LINK 'Has 'Wit)
                                (LINK 'Knows 'Tricks 0.8))
     (CONCEPT 'Wit) 
     (CONCEPT 'Tricks)
     
     (CONCEPT 'Adventurer (AKO 'Human)
                          (LINK 'Hates 'Danger 0.1)
                          (LINK 'Has 'Curiosity 0.7))
     (CONCEPT 'Curiosity (LINK 'Has 'Danger 0.3))
     (CONCEPT 'Danger)
     
     (CONCEPT 'Human (AKO 'Creature)
                     (LINK 'Is 'Mortal)
                     (LINK 'Has 'Dignity 0.5)
                     (LINK 'Likes 'Money 0.7))
     (CONCEPT 'Mortal) 
     (CONCEPT 'Dignity) 
     (CONCEPT 'Money)
     
     (CONCEPT 'Creature '(Has Life))
     (CONCEPT 'Life)
     
     (CONCEPT 'Magician (AKO 'Human)
                        (LINK 'Has 'Money 0.5)
                        (LINK 'Knows 'Spells)
                        (LINK 'Likes 'Power 0.5)
                        (LINK 'Likes 'PracticalJoke 0.2))
     (CONCEPT 'Spells) 
     (CONCEPT 'Power)
     (CONCEPT 'PracticalJoke)
     
     (CONCEPT 'Monster (AKO 'Creature)
                       (LINK 'Has 'BadBreath 0.9)
                       (LINK 'Owns 'Treasures 0.1)
                       (LINK 'Has 'Curiosity 0.5))
     (CONCEPT 'BadBreath)
     (CONCEPT 'Treasures)
     (CONCEPT 'SweetNature)))
  
= (FindConcept DyingEarth-Fuzzy 'Cugel)
  (Cugel ((AKO (StoryCharacter CleverAdventurer))
          (Is Pretty 0.5)))
  
= (GetAKOChain DyingEarth-Fuzzy 'Cugel)
  (Cugel StoryCharacter CleverAdventurer Adventurer Human Creature)
  
? (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Has 0.0)
  (list '(Has Wit) '(Has Curiosity 0.7) '(Has Dignity 0.5)
        (list 'Has 'Danger (* 0.7 0.3))
       '(Has Life))
  
= (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Has 0.5)
  ((Has Wit) (Has Curiosity 0.7) (Has Dignity 0.5) (Has Life))
  
= (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Has)
  ((Has Wit) (Has Life))
  
= (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Hates 0.0)
  ((Hates Danger 0.1))
  
= (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Is 0.0)
  ((Is Pretty 0.5) (Is Imaginary 0.5) (Is Mortal))

= (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Is 0.7)
  ((Is Mortal))

= (FindAllLinkedConcepts DyingEarth-Fuzzy 'Cugel 'Is 1.0)
  ((Is Mortal))

? (FindAllLinkedConcepts DyingEarth-Fuzzy 'Sadlark 'Has 0.0)
  (list '(Has Curiosity 0.5) '(Has BadBreath 0.9) '(Has Life)
        (list 'Has 'Danger (* 0.5 0.3)))

= (FindAllLinks DyingEarth-Fuzzy 'Cugel 'Mortal 0.0)
  ((Is Mortal))

? (FindAllLinks DyingEarth-Fuzzy 'Cugel 'Danger 0.0)
  (list '(Hates Danger 0.1)
        (list 'Has 'Danger (* 0.7 0.3)))

? (FindAllLinks DyingEarth-Fuzzy 'Cugel 'Danger 0.2)
  (list (list 'Has 'Danger (* 0.7 0.3)))

= (FindAllLinks DyingEarth-Fuzzy 'Cugel 'Creature 0.0)
  (AKO)

= (Linked? DyingEarth-Fuzzy 'Cugel 'Danger 0.0)
  #t

= (Linked? DyingEarth-Fuzzy 'Cugel 'Danger 1.0)
  #f

= (Linked? DyingEarth-Fuzzy 'Cugel 'Creature 1.0)
  #t

; tests from section 3.5.2 of book

!	(define 
    CugelsSaga 
    (MakeAN
     (CONCEPT 'Creature 
              (LINK 'has 'life))
     (CONCEPT 'Monster (AKO 'Creature) 
                       (LINK 'has 'curiosity 0.5)
                       (LINK 'owns 'treasure))
     (CONCEPT 'sadlark (AKO 'Monster) 
                       (LINK 'has 'strength))
     (CONCEPT 'Human (AKO 'Creature) 
                     (LINK 'likes 'money 0.5)
                     (LINK 'is 'mortal))
     (CONCEPT 'drofo (AKO 'Human))
     (CONCEPT 'Adventurer (AKO 'Human) 
                          (LINK 'has 'curiosity)
                          (LINK 'likes 'danger 0.9))
     (CONCEPT 'StoryCharacter 
              (LINK 'is 'imaginary 0.7))
     (CONCEPT 'cugel 
              (AKO 'Adventurer 'StoryCharacter) 			   
              (LINK 'is 'clever))
     (CONCEPT 'life (LINK 'has 'danger))
     (CONCEPT 'treasure)
     (CONCEPT 'money)
     (CONCEPT 'strength)
     (CONCEPT 'danger)
     (CONCEPT 'mortal)
     (CONCEPT 'curiosity (LINK 'has 'danger 0.5))
     (CONCEPT 'clever)
     (CONCEPT 'imaginary)))  

!	(PrintAN CugelsSaga)

!	(define bunderwalConcept 
        (CONCEPT 'bunderwal(AKO 'adventurer)))
= bunderwalConcept
  (bunderwal ((ako (adventurer)))) 

! (define CugelsSaga
        (AddConcept CugelsSaga bunderwalConcept))
; ((creature ... 
;	  (imaginary ()) (bunderwal ((ako (adventurer)))))

! (set! CugelsSaga 
        (RemoveConcept CugelsSaga 'bunderwal))
; ((creature ... (imaginary ()))

!	(set! CugelsSaga 
        (AddLink CugelsSaga 'sadlark (LINK 'can 'fly)))
; ((creature ... (sadlark ((ako (monster)) 
;         (has strength) (can fly))))

!	(set! CugelsSaga
        (RemoveLink CugelsSaga 'sadlark 'can))
; ((creature ... (sadlark ((ako (monster)) 
;          (has strength))))

! (set! CugelsSaga 
        (AddAkoLink CugelsSaga 'cugel 'monster))
; ((creature ... 
;	  (ako (adventurer storycharacter monster)))))

= (Linked? CugelsSaga 'cugel 'treasure 0.9)
  #t
    
! (set! CugelsSaga 
        (RemoveAkoLink CugelsSaga 'cugel 'monster))

= (Linked? CugelsSaga 'cugel 'treasure 0.9)
  #f

! (set! CugelsSaga 
        (AddLink CugelsSaga 'sadlark 
                            (LINK 'is 'vicious)))
  ; NOTE: the concept "vicious" has not been defined in the net
  ; ((creature ... (has strength) (is vicious))))

= (GetLinkSymbolSlots CugelsSaga 'sadlark 'is)
  ((is vicious))  
    
! (set! CugelsSaga 
        (RemoveLink CugelsSaga 'sadlark 'is))

= (GetLinkSymbolSlots CugelsSaga 'sadlark 'is)
  ()

=	(FindAllConcepts CugelsSaga)
	 (creature monster human drofo adventurer storycharacter
   life treasure money strength danger mortal curiosity
   clever imaginary cugel sadlark)

= (FindAllLinkNames CugelsSaga)
  (is likes owns has)

= (FindConcept CugelsSaga 'adventurer)
	 (adventurer ((ako (human)) (has curiosity) (likes danger 0.9)))

= (GetAkoSlot CugelsSaga 'cugel)
  (ako (adventurer storycharacter))

= (GetAkoLinks CugelsSaga 'cugel)
	 (adventurer storycharacter)

= (GetAkoChain CugelsSaga 'cugel)
	 (cugel adventurer storycharacter human creature)

= (GetAkoChain CugelsSaga 'sadlark)
  (sadlark monster creature)

= (GetLinkSymbolSlots CugelsSaga 'cugel 'is)
	 ((is clever))

= (FindAllLinkedConcepts CugelsSaga 'cugel 'is)
	 ((is clever) (is mortal))

= (FindAllLinkedConcepts CugelsSaga 'cugel 'is 0.5)
	 ((is clever) (is imaginary 0.7) (is mortal))

= (FindAllLinks CugelsSaga 'adventurer 'danger)
	 ((has danger))

= (FindAllLinks CugelsSaga 'adventurer 'danger 0.5)
  ((likes danger 0.9) (has danger 0.5) (has danger))

! (define Love 
    (MakeAN 
     (CONCEPT 'bruce (LINK 'loves 'jane 0.8))
     (CONCEPT 'jane  (LINK 'loves 'bruce 0.9)) ))

= (FindAllLinks Love 'bruce 'jane 0.2)
	 ((loves jane 0.8)
   (loves jane 0.576)
   (loves jane 0.41472)
   (loves jane 0.298598)
   (loves jane 0.214991))
  
! (set! CugelsSaga
        (RemoveLink CugelsSaga 'life 'has))
  
= (Linked? CugelsSaga 'sadlark 'danger)
	 #f

=	(Linked? CugelsSaga 'sadlark 'danger 0.25)
  #t
