;;;
;;;   S Y S T E M   T O O L B O X
;;;   = = = = = =   = = = = = = =
;;;
;;; System Dependent Toolbox
;;;
;;; This toolbox localizes those calls to routines that are specific
;;; to a particular implementation.
;;;
;;; This version is specific to MacScheme
;;;

(define *SchemeVersion* "MacScheme")

; The following is the most negative/positive fixnum. They are used
; for example as the value of a state in the search toolbox of
; little/great relevance.

(define NEG-INFINITY -536870911)
(define INFINITY     +536870911)

; Output
; ------
; Allow multiple argument form of display with and without final newline

(define DisplayLine 
  (lambda someArgs
    (for-each (lambda (arg) 
                (display arg) (display " "))
              someArgs)
    (newline)))

(define DisplayList
  (lambda someArgs
    (for-each (lambda (arg) 
                (display arg) (display " "))
              someArgs)))

; Error handling
; --------------
; All detected errors in the toolboxes call Fatal-Error with a
; message describing the error. If a routine named Error-Continuation
; has been defined it is called instead of the system debugger

(define Error-Continuation #f)

(define Fatal-Error
  (lambda aMessageList
    (display "TOOLBOX ERROR: ")
    (for-each (lambda (aMessage)
                (display " ")
                (display aMessage))
              aMessageList)
    (newline)
    (if Error-Continuation
          (Error-Continuation "ERROR-VALUE")
          (error "TOOLBOX ERROR: "))))

; Testing
; -------
; The following routines are only called in the testing routines so that
; it is not necessary that it be defined to use the toolbox. The
; functions 'eval' and 'pretty-print' are not part of standard R^3
; scheme but are available in many implementations.

(define EvalExp (lambda (anExp) (eval anExp)))

(define MyPrettyPrint (lambda (anExp) (pretty-print anExp)))

; Random Numbers
; --------------
; The following routine is called in places such as where a move is
; to be chosen at random from a list of equally suitable candidates.
; This function is suitable only for noncritical uses.

(define MyRandom
  (lambda (n)
    ; Returns a pseudo-random nonnegative integer less than a
    ; positive integer n.
    (random n)))

; Mac Graphics (specific to MacScheme)
; ------------
; Allow the use of graphics. Set up the graphics window and set
; variable AllowGraphics to notify display routines

(define AllowGraphics #f)

(define BeginGraphics (lambda () (set! AllowGraphics #t) (start-graphics 'half)))

(define EndGraphics (lambda () (set! AllowGraphics #f) (end-graphics)))
