; test of LineLand microworld
;

! (SetUpLineLand)
! (define *g (GetGoalFN LL-SearchProblem))

= (*g '(e l l s s))
  #f

= (*g '(e s s l l))
  #t

! (define *e (GetEvalFN LL-SearchProblem))

= (*e '(e l l s s))
  -11

= (*e '(e s s l l))
  0

! (define *l2 (FirstAction (GetActions LL-SearchProblem)))

= (*l2 '(l l e s s))
  (e l l s s)

= (*l2 '(l e l s s))
  #f

= (DFSearch LL-SearchProblem 2)
  #f

= (DFSearch LL-SearchProblem 8)
  (8 148 (#(ok NEG-INFINITY (s s l e l))
          #(ok NEG-INFINITY (s e l s l))
          #(ok NEG-INFINITY (e s l s l))
          #(ok NEG-INFINITY (l s e s l))
          #(ok NEG-INFINITY (l s l s e))
          #(ok NEG-INFINITY (l s l e s))
          #(ok NEG-INFINITY (l e l s s))
          #(ok NEG-INFINITY (e l l s s))))
  
= (BFSearch LL-SearchProblem)
  (8 440 (#(ok NEG-INFINITY (s s l e l))
          #(ok NEG-INFINITY (s e l s l))
          #(ok NEG-INFINITY (e s l s l))
          #(ok NEG-INFINITY (l s e s l))
          #(ok NEG-INFINITY (l s l s e))
          #(ok NEG-INFINITY (l s l e s))
          #(ok NEG-INFINITY (l e l s s))
          #(ok NEG-INFINITY (e l l s s))))
  
= (HillSearch LL-SearchProblem 11)
  (10 72 (#(ok 0 (s e s l l))
          #(ok -1 (s l s e l))
          #(ok -1 (s l s l e))
          #(ok -4 (s l e l s))
          #(ok -6 (e l s l s))
          #(ok -6 (l e s l s))
          #(ok -11 (l l s e s))
          #(ok -11 (l l e s s))
          #(ok -11 (l e l s s))
          #(ok -11 (e l l s s))))
  
= (HillSearch LL-SearchProblem 99)
  (13 56 (#(ok 0 (s s l e l))
          #(ok -1 (s e l s l))
          #(ok -1 (s l e s l))
          #(ok -4 (s l l s e))
          #(ok -4 (s l l e s))
          #(ok -4 (s e l l s))
          #(ok -4 (s l e l s))
          #(ok -6 (e l s l s))
          #(ok -6 (l e s l s))
          #(ok -11 (l l s e s))
          #(ok -11 (l l e s s))
          #(ok -11 (l e l s s))
          #(ok -11 (e l l s s))))
  
= (SteepestSearch LL-SearchProblem)
  (12 44 (#(ok 0 (s s l e l))
          #(ok -1 (s e l s l))
          #(ok -1 (e s l s l))
          #(ok -3 (l s e s l))
          #(ok -3 (l s s e l))
          #(ok -3 (l s s l e))
          #(ok -6 (l s e l s))
          #(ok -6 (l e s l s))
          #(ok -11 (l l s e s))
          #(ok -11 (l l s s e))
          #(ok -11 (l l e s s))
          #(ok -11 (e l l s s))))
  