; Section 3.4.3: GuessWho example

; two sound procedures

(define Wail
  (lambda (aNumber)
    (do ((i aNumber (- i 1)))
        ((zero? i))
        (DisplayLine "Whaiiiiiillll...") )))

(define Honk 
  (lambda () (DisplayLine "Honk honk ...")))

; announce the monster after the forward chainer's return

(define ItsA
  (lambda (aWM monster)
    (DisplayLine "Don't worry it's only a" monster)
    (list 'ItsA monster) ))

(define 
  *PM*
  (MakePM
   (RULE 'bansheeRule 
         (CONDITIONS (PATTERN (? 'who) 'is 'loud)
                     (PATTERN (<-? 'who) 'is 'scary))
         (CONCLUSIONS (ASSERT (PATTERN (<-? 'who) 'is 'a 'banshee))
                      (EXECUTE Wail 3) ;  just for it weird effect
                      (RETURN ItsA 'banshee)))
   (RULE 'cheshireCatRule 
         (CONDITIONS (PATTERN (? 'who) 'is 'invisible)
                     (PATTERN (<-? 'who) 'is 'friendly)
                     (~ (PATTERN (<-? 'who) 'is 'scary)))
         (CONCLUSIONS (ASSERT (PATTERN (<-? 'who) 'is 'a 'cheshire-cat))
                      (RETURN ItsA 'cheshire-cat)))
   (RULE 'squonkRule 
         (CONDITIONS (PATTERN (? 'who) 'is 'green)
                     (PATTERN (<-? 'who) 'is 'friendly)
                     (PATTERN (<-? 'who) 'is 'sad))                           
         (CONCLUSIONS (ASSERT (PATTERN (<-? 'who) 'is 'a 'squonk))
                      (EXECUTE Honk)
                      (RETURN  ItsA 'squonk)))
   (RULE 'alligatorRule 
         (CONDITIONS (PATTERN (? 'who) 'is 'green)                                   
                     (~ (PATTERN (<-? 'who) 'is 'friendly))
                     (PATTERN (<-? 'who) 'is 'scary))
         (CONCLUSIONS (ASSERT (PATTERN (<-? 'who) 'is 'an 'alligator))
                      (RETURN ItsA 'alligator)))))

(define *WM* (MakeWM))

(define GuessWhosHidingUnderYourBed
  (lambda ()
    
    (define result #f)
    
    (define ask!
      (lambda (aString yesFact noFact)
        ; ask question and get their reply
        ; if they answer yes add the yesFact to *WM*
        ; if they answer no  add the noFact  to *WM*
        
        (define addRealFact!
          (lambda (aFact)
            ; add aFact to *WM* if not null
            (if (not aFact)
		#f
		(set! *WM* (AddFact *WM* aFact)))))
        
        (let ((reply #f)
              (yesReplies '(Yes yes y yep YES))
              (noReplies  '(No no n nope NO)))
          (newline)
          (DisplayLine aString)
          (set! reply (read))
          (cond ((member reply yesReplies)
                 (addRealFact! yesFact))
                ((member reply noReplies)
                 (addRealFact! noFact))
                (else 
                 (newline)
                 (DisplayLine 
                  "I don't understand your answer")
                 (ask! aString yesFact noFact))))))
    
    ; setting the scene
    (set! *WM* (MakeWM))
    (DisplayLine "Oh oh, I think there is a monster under your bed !")
    (DisplayLine "Take a careful peek and tell me what it looks like")
    (DisplayLine "Don't take chances, just guess if you can't see it properly")
    ; start asking for properties and make appropriate
    ; assertions into the *WM*
    (ask! "Can you see it at all ?" #f '(thingy is invisible))
    (ask! "Can you see it grin ?" '(thingy is friendly) #f)
    (ask! "Is it green all over ?" '(thingy is green) #f)
    (ask! "Does it wail a lot ?" '(thingy is loud) #f)
    (ask! "Does it look sad ?" '(thingy is sad) #f)
    (ask! "Are you scared of it ?" '(thingy is scary) #f)
    (newline)
    ; now invoke the forward chainer to deduce the thingys
    ; nature based on these answers and the rules in the *PM*
    (set! result (ForwardChainer *PM* *WM*))
    (newline)
    ; if RETURN has returned a conclusion, then it will already
    ; have been announced by the associated procedure - do nothing.
    ; Otherwise conclude that it must be a "hide behind", which
    ; one can never see (since it is always behind one; by definition)
    
    (if (and (pair? result) (equal? (car result) 'ItsA))
        #f
        (displayLine "Must be a hidebehind then")) ))

(DisplayLine
 "Type (GuessWhosHidingUnderYourBed) to identify monsters")
