; ========== THE QUEEN'S GARDEN PARTY - a Queueing Model ==========

; ===== The Monitor =====

(makeinstance (GardenParty Monitor))

; ===== Distributions =====

(makeInstance (LoyalsArrive ConstantDist) ((name "arrivals") (value 2)) )
(GardenParty 'addDistributions! LoyalsArrive)

(makeInstance (ShakeDist ConstantDist) ((name "service") (value 1)) )
(GardenParty 'addDistributions! ShakeDist)

(makeInstance (Again? DrawDist) ((name "once more ?") (%true 0.5)) )
(GardenParty 'addDistributions! Again?)

; ===== Servers =====

(makeInstance (Queen Server) ((monitor     GardenParty)
                              (capacity    1)
                              (q           (FifoQueue 'new)) ) )

; ===== Transactions =====

(defFlavour LoyalSubject (ako Transaction))

(defCoroutine (shakeQueen LoyalSubject) ()
  (let ((more #t))
    (while more
           (display "hi !: ") (display more) (newline) 
           (Queen 'acquire! self 1)
    							(display "grab queen at ") (display ((self 'monitor) 'clockTime)
           (newline) 
  							  (self 'hold 'shakeQueen (ShakeDist 'sample))
    							(display "release queen at ") (display ((self 'monitor) 'clockTime)
           (newline) 
  							  (Queen 'release! 1)
           (set! more (Again? 'sample)))
    (ThatsAllItTook 'depart! self)))

; ===== Sources & Sinks =====

(makeInstance (Arrivals Source) ((monitor        GardenParty)
                                 (processFlavour LoyalSubject)
                                 (processParams  nil)
                                 (methodName     'shakeQueen)
                                 (arrivalDist    LoyalsArrive) ) )

(makeInstance (ThatsAllItTook Sink) ((monitor GardenParty)))
(GardenParty 'addDataCollectors! ThatsAllItTook)

;;; oooooOOOOOooooo now run the GardenParty oooooOOOOOooooo

(GardenParty 'simulate! 10)
(GardenParty 'tracing?! #t)
(Queen 'tracing?! #t)
(Arrivals 'tracing?! #t)
(Arrivals    'startUp!  10)
(GardenParty 'startUp!)

(GardenParty 'reset)
(Arrivals 'reset)
(Queen 'reset)

(GardenParty 'report)
(Queen 'show)

