; Compatibility file for the Abelson and Sussman textbook.

; sequence is synonymous with begin

(macro sequence
       (lambda (l)
         `(begin ,@(cdr l))))

; old-fashioned I/O procedure names

(define (print x . p)
  (if p (set! p (car p)) (set! p (current-output-port)))
  (newline)
  (write x p))

(define princ display)

; explode, implode (isn't this code ugly?)

(define (explode symbol)
  (map (lambda (x) (string->symbol (list->string (list x))))
       (string->list (symbol->string symbol))))

(define (implode char-list)
  (string->symbol
   (list->string (map (lambda (x)
                        (car (string->list
                              (symbol->string x))))
                      char-list))))

; property lists

(define (put var property value)
  (if (null? var) (set! var 'nil))
  (if (not (symbol? var))
      (error "Non-symbol argument to put" var))
  (if (eq? property 'pname)
      (error "The pname property is inviolate" var))
  (let ((entry (assq property (cdr (->pair var)))))
    (if entry
        (set-cdr! entry value)
        (set-cdr! (->pair var)
                  (cons (cons property value)
                        (cdr (->pair var)))))
    value))

(define (get var property)
  (if (null? var) (set! var 'nil))
  (if (not (symbol? var))
      (error "Non-symbol argument to get" var))
  (let ((entry (assq property (cdr (->pair var)))))
    (if entry (cdr entry) #!false)))

; One of the differences between MacScheme Version 0 and Version 1
; is that Version 1 has a two-argument eval.  It isn't documented yet,
; however, because it will soon change to use a more abstract kind of
; environment as its second argument.  Environments in Version 1
; aren't abstract at all.  For example, you can take the car of some
; environments, which doesn't make any sense.

(define user-initial-environment '())

(macro make-environment
       (lambda (l)
         `((lambda ()
             ,@(cdr l)
             (cdr (->pair (lambda () 0)))))))     ; yuck

; exception handler to make the car and cdr of the empty list be
; the empty list.  The query system relies on this.

(let ((old-handler (vector-ref **error-code-table** 14)))
  (vector-set!
   **error-code-table**
   14
   (lambda (errcode bytecode machine-state)
     (if (null? (car (vector-ref machine-state 0)))
         (begin (set-car! (vector-ref machine-state 0) '(()))
                (restart-machine-state machine-state))
         (old-handler errcode bytecode machine-state))))
  #!true)
