(define DisplayLine 
  (lambda someArgs
    (for-each (lambda (arg) 
                (display arg) (display " "))
              someArgs)
    (newline)))

(define DisplayList
  (lambda someArgs
    (for-each (lambda (arg) 
                (display arg) (display " "))
              someArgs)))

(define MyRandom
  (lambda (n)
    ; Returns a pseudo-random nonnegative integer less than a
    ; positive integer n.
    (random n)))

(define MeaningOfLife 42)
(+ MeaningOfLife 7)

(quote (define MeaningOfLife 42))
(define MeaningOfLife 42)

'(define MeaningOfLife 42)
(define MeaningOfLife 42)

(eval (quote (MeaningOfLife 42)))

(define LuckyNumber (read)) ; 7 is entered
; LuckyNumber
LuckyNumber
; 7
(display LuckyNumber)
; 7 #t

(DisplayLine LuckyNumber "is not" 13)
; 7is not 13 #t

(eqv?  (list 'a) (list 'a)) ; they "look the same", but are 	; ()
(eq?   (list 'a) (list 'a)) ; stored in different memory cells.
; ()
(equal?(list 'a) (list 'a))
; #t

42
; 42
3.14
; 3.14
1.0e10
; 10000000000

(number? 7)
; #t
	
(odd? 3.14)
; ERROR: Non-integer argument to function - 3.14
(/ 3 2)
; 1.5
(expt 2 3)
; 8
(floor 3.14)
; 3
(round  7.7)
; 8
(=? 7 13)
; ()

(number->string (sqrt 3.14))
; "1.772"

(boolean? '())
; #t
(and #t #t)
; #t
(or #f (<? 7 0))
; ()

#\x
; 120
#\y
; 121
#\space
; 32

(display "the \" character delimits a string")
; the " character delimits a string

(string-length "mumble")
; 6
(string-append "mumble " "mumble")
; "mumble mumble"
(string-ref "mumble" 4)
; 108

MeaningOfLife
; 42
(quote MeaningOfLife)
; MeaningOfLife
(quote X)
; X
X
; ERROR: Undefined global variable X

(define Capnomancy 
            "study of smoke to determine the future")
; Capnomancy
(set! MeaningOfLife Capnomancy)
; MeaningOfLife
MeaningOfLife
; "study of smoke to determine the future"

(symbol? (string->symbol "Capnomancy"))
; #t

'(HappyMole LittleBear LittleTiger)
; (HappyMole LittleBear LittleTiger)

(HappyMole LittleBear LittleTiger)
; ERROR: undefined global variable LittleTiger

MeaningOfLife
; "study of smoke to determine the future"
('MeaningOfLife)
; ERROR: Bad procedure MeaningOfLife
(MeaningOfLife)
; ERROR: Bad procedure 
"study of smoke to determine the future"

(cons 'LittleBear 'LittleTiger) ; make a "dotted pair"
; (LittleBear . LittleTiger)

(cons 'HappyMole 
   (cons 'LittleBear 
      (cons 'LittleTiger #f))) ; as in figure 2.12
; (HappyMole LittleBear LittleTiger)

(list 'HappyMole 'LittleBear 'LittleTiger)
; (HappyMole LittleBear LittleTiger)

(append '(HappyMole LittleBear LittleTiger) 	 		  
             '(AuntyGoose))
; (HappyMole LittleBear LittleTiger AuntyGoose)

(pair? '(LittleTiger))
; #t
(null? ())
; #t

(length '(troll banshee vampire))
; 3
(car '(troll banshee vampire))
; troll
(cdr '(troll banshee vampire))
; (banshee vampire)
(car (cdr (cdr '(troll banshee vampire))))
; vampire
(caddr '(troll banshee vampire))
; vampire
(list-tail '(troll banshee vampire) 2)
; (vampire)
(list-ref '(troll banshee vampire) 2)
; vampire

(member 'vampire '(troll banshee vampire))
; (vampire)
(member 'banshee '(troll banshee vampire))
; (banshee vampire)
(assoc  'LittleBear '((HappyMole vampire) 			                
(LittleBear banshee) (LittleTiger troll)))
; (LittleBear banshee)

(list->string '(#\b #\e #\a #\r))
; "bear"
(string->list "bear")
; (98 101 97 114)

 (vector 7 "is one of" '(7 13 42) )
; #(7 "is one of" (7 13 42) )

(define Friends (make-vector 5))
; #( () () () () () )
(vector-set! Friends 0 'bear)
; #( bear () () () () )
(vector-length Friends)
; 5
(vector-ref Friends 1)
; ()
(vector-ref Friends 0)
; bear
(vector->list Friends)
; ( bear () () () () )

; a "fancy dress" party
(define party '((HappyMole vampire) 
                       (LittleBear 	banshee) 
                       (LittleTiger troll))) 
; party 
;  and a "guessing game"
(cond ((equal? (assoc 'HappyMole party) 
                       '(HappyMole troll)) 
            "moles are trolls")
         ((equal? (assoc 'LittleBear party) 
                       '(LittleBear 	banshee)) 
            "bears are banshees")
	((equal? (assoc 'LittleTiger party) 
                       '(LittleTiger troll)) 
           "tigers are trolls")
	(else "bad guess ?")
; bears are banshees

; looking for tiger  as the key of the first pair in 'party'
(if (equal? (caar party) 'LittleTiger)
     (display "tiger is first")
     (display "keep looking"))
; keep looking #t

; looking for mole as the key of the first pair in 'party'
(if (equal? (caar party) 'HappyMole)
     (begin (DisplayLine "mole is first") 
                (display "who's next ?"))
                (display "keep looking"))
; mole is first
; who's next ? #t

(set! age 42)
(case (+ age 1)
	 ((6    ) 'excited)
	 ((21   ) 'rejoicing)
	 ((30 40) 'depressed)
	 (else 'indifferent))
; indifferent

 ; Owl's birthday party
(set! luckyFellow 'owl)
(DisplayList "an ideal pet for" luckyFellow " would be a ")
(display (case luckyFellow
              ((tiger bear mole)	"dog")
              ((owl)             	"tortoise")
              ((fox)                     "snake")
              ((duck elephant)    "goldfish")
              (else "???")) )
; an ideal pet for owl would be a tortoise

(let ((friends '(mole bear tiger)))
        (do ((next  friends (set! next (cdr next))))
                ((null? next) "all clean now !")
                (DisplayLine "wash " (car next)))) 
; wash mole
; wash bear 
; wash tiger
; "all clean now !"

(for-each display party)
; (HappyMole vampire) (LittleBear banshee)  	     
; (LittleTiger troll) ()

(map abs '(1 -2 -3))
; (1 2 3)

(lambda () "hi there")
; #<PROCEDURE>

( (lambda () "hi there") )
; "hi there"
((lambda (aFriend) ; one parameter: aFriend 
       (DisplayLine "hi there " aFriend))   
  'HappyMole) ; invoked with one argument: HappyMole 
; hi there HappyMole #t

((lambda someFriends  ; no brackets around parameter !
      (DisplayLine "hi there " someFriends))   
  'mole 'bear 'tiger) ; invoked with 3 arguments
; hi there (mole bear tiger) #t

((lambda someFriends  
      (DisplayLine "hi there " someFriends)) ) 	
; invoked with 0 arguments
; hi there () #t  

; one mandatory and some optional parameters
((lambda (aFriend . someMore)                	 	    
(DisplayLine "hi there " someMore)) 'mole 'bear 'tiger) 
; three arguments
; hi there (bear tiger) #t     ; mole is now bound to "aFriend"

((lambda (aFriend . someMore)  
       (DisplayLine "hi there " someMore)))
; no arguments
; ERROR: Too few arguments to procedure
; 0 arguments supplied - 1 argument expected

(procedure? (lambda () (display "hello")))
; #t

(apply (lambda (aFriend) (DisplayLine "hello" aFriend)) 	       	       
          '(mole) )
; hello mole #t

(let ((seven 7) (thirteen 13))
    (DisplayLine (* seven thirteen))  
    (+ seven thirteen))
; 91 ; result of multiplication
; 20 ; result of addition

(let ((aNumber 7) (twiceThat (* 2 aNumber)))
     (display twiceThat) )
; ERROR: Undefined global variable aNumber

(let* ((aNumber 7) (twiceThat (* 2 aNumber)))
      (display twiceThat) )
; 14 #t

(define head car)
; head

(define tail  cdr)
; tail

(head (tail '(vampire banshee troll)))
; banshee

(set! + *) ; sneaky: redefine + as multiplication symbol ?
; ERROR: Integrable procedures may not be redefined

(define GenericMagicLamp
     ; this is the "lambda" we wish to return
     (lambda (noOfWishes)                        
          (define count 0) ; local variable
          (lambda ()
               (if (<? count noOfWishes)
                    (begin (set! count (+ 1 count))  
                               'Granted)
                    "you've had all you're going to get !")) ))
   ; GenericMagicLamp

(define AlladinsLamp (GenericMagicLamp 3))
; AlladinsLamp

(AlladinsLamp)
; granted
(AlladinsLamp)
; granted
(AlladinsLamp)
; granted
(AlladinsLamp)
; "you've had all you're going to get !"

; hard luck  - "count" is  kept private to this lamp object, and can't 
; be accessed !
(set! count 0)
; ERROR: Undefined global variable count 

(define GoodBye (lambda () (display ".") (GoodBye)))
(GoodBye)

(define StoryTeller 
    (lambda (mainCharacter someFriends)
    
       (define chorus 
           (lambda (someFriends caravan)
                ; check for termination
                (if (null? someFriends)             		
	            #f
                     (begin  
                        ; greet a friend
                        (DisplayLine (car someFriends))
                        ; and "walk down" all the ones who have already
                        ; joined
             	      (display "with ")
                        (map (lambda (aFriend)
                                (DisplayLine aFriend)
                                (display "and "))
                             caravan)
                       (DisplayLine "...")  
                       ; recurse on another friend (and let this one join the
                       ; "caravan")               
             	     (chorus (cdr someFriends) 
                              (append 
                                 caravan 
                                 ; needs a list here !
                                (list  
                                  (car someFriends)))                     
				))) )) 

          ; body of "StoryTeller" function
    	  (DisplayLine "out of the gate and off for a walk went")
    	  (DisplayLine mainCharacter " ...") 
           (newline)
    
           (chorus someFriends (list mainCharacter))
    
           ; we will skip some more friends here, and also their    
           ; encounter with Scareface Claw (the toughest Tom in town)
    
    	  (newline) 
           (display "straight back home to bed") ))
 ; StoryTeller


(StoryTeller 
         "Hairy MacLary from Donaldson's Dairy"
         '("Hercules Morse, as big as a horse"
           "Bottomley Potts, covered in spots"
           "Muffin McLay, like a bundle of hay"))

; out of the gate and off for a walk went
; 
;
; Hercules Morse, as big as a horse
; with Hairy MacLary from Donaldson's Dairy
; and ... 
; Bottomley Potts, covered in spots
; with Hercules Morse, as big as a horse
 ; and Hairy MacLary from Donaldson's Dairy
; and ... 
; Muffin McLay, like a bundle of hay
; with Bottomley Potts, covered in spots
; and Hercules Morse, as big as a horse
; and Hairy MacLary from Donaldson's Dairy
; and ... 
;
; straight back home to bed#t

(define HowMuchMoneyDoWeHave 
    (lambda (someFriends)
    
      	(define count (lambda (aFriend) (cadr aFriend)))

    	(trace count)

         ; body of "HowMuchMoneyDoWeHave" procedure
    	(if (null? someFriends) ; termination condition
     	     0
	     ; add it all up
     	     (+ (count (car someFriends))     ; this much
       	         (HowMuchMoneyDoWeHave     ; and more
                        (cdr someFriends)))) ))
; HowMuchMoneyDoWeHave

(trace HowMuchMoneyDoWeHave)
; #t

(HowMuchMoneyDoWeHave
'((HappyMole 3) (LittleBear 1) (LittleTiger 0)))

will print:

	Computing 
               (#<PROCEDURE howmuchmoneydowehave> 
                    ((happymole 3) (littlebear 1) 
                     (littletiger 0)))
	   Computing (#<PROCEDURE howmuchmoneydowehave> 	     
                      ((littlebear 1) (littletiger 0)))
	      Computing (#<PROCEDURE howmuchmoneydowehave>  
                        ((littletiger 0)))
	         Computing (#<PROCEDURE howmuchmoneydowehave> 
                           ())
	         (#<PROCEDURE howmuchmoneydowehave> ()) --> 0
                    Computing (#<PROCEDURE count>  
                                 (littletiger 0))
                    (#<PROCEDURE count> (littletiger 0)) 
                                                     --> 0
	        (#<PROCEDURE howmuchmoneydowehave> 
                        ((littletiger 0))) --> 0
	     Computing (#<PROCEDURE count> (littlebear 1))
	     (#<PROCEDURE count> (littlebear 1)) --> 1
                (#<PROCEDURE howmuchmoneydowehave> 
                     ((littlebear 1) (littletiger 0))) --> 1
	Computing (#<PROCEDURE count> (happymole 3))
	 (#<PROCEDURE count> (happymole 3)) --> 3
	(#<PROCEDURE howmuchmoneydowehave> 
             ((happymole 3) (littlebear 1) (littletiger 0))) 
               --> 4
   	; 4

(define WandGenerator 
    (lambda (aCharge)
    
        ; instance variables in addition to "aCharge" 
        ; may be defined here
    
        ; methods:
    	 (define charge (lambda () aCharge))

          (define spellOfSlimyExile
             (lambda (aVictim) (list 'toad aVictim)))

          (define spellOfBedazzlement
             (lambda (aVictim) (list 'pretty aVictim)))
    
          ; dispatch defines the message protocol
         (define dispatch 
            (lambda aMessage
               (if (equal? (car aMessage) 'charge) 
                   ; don't decrement aCharge if wand is already empty
                   (charge)
                   ; check which spell and decrement aCharge
                   (begin 
                     (if (<=? aCharge 0)
                         "..."
                         (begin
                           ; spells always take "spellenergy" 
                           ; (even if they fail !)
                   	 (set! aCharge (- aCharge 1)) 
                   	 (cond 
                             ((equal? (car aMessage) 'toad)
                              (apply spellOfSlimyExile (cdr aMessage)))
                             ((equal? (car aMessage) 'pretty)
                              (apply spellOfBedazzlement (cdr aMessage)))
                             (else 'poof))) ))) )) 
        
    	  ; the "value" (body) of dispatch will be returned 
           ; by WandGenerator
           dispatch))
 ;WandGenerator

(define CheapWand (WandGenerator 3))
; CheapWand

(CheapWand 'charge)
; 3
(CheapWand 'curse 'cugel)
; poof
(Cheapwand 'toad 'cugel)
;(toad cugel)
(CheapWand 'pretty 'cugel)
; (pretty cugel)
(Cheapwand 'toad 'kermit)
; "..."
(Cheapwand 'charge)
; 0

(define StoredContinuation #f)
; StoredContinuation

(define SayHiTo
    (lambda (aFriend)
  	 ; capture and store this program's continuation 
   	 (call-with-current-continuation 
    	   (lambda (aContinuation)
    	     (set! StoredContinuation aContinuation)) )
    	 (DisplayLine "hi " aFriend)) )
; SayHiTo
(SayHiTo 'spot)
; hi spot #t

(StoredContinuation #f)

; hi spot #t

(define SayHiAgain
    (lambda (aFriend)
   	 (display     
    	        (list 'hi
     	                ; now capture the continuation
                         ; within an "unfinished" evaluation
       	                (call-with-current-continuation
         	          (lambda (aContinuation)
            	             (set! StoredContinuation aContinuation) 
                              ;this is the value returned from "call-with ..."
                              ; note: when the captured continuation 
                              ; is invoked , it will return the value of its 
                              ; argument ! 
			   ; (so this one will be "listed" instead) 
                              aFriend)) ))
           (display ", ") ))
; sayhiagain

(SayHiAgain 'spot)
; (hi spot), #t
(StoredContinuation 'sally)
; (hi sally), #t

(define HiInContext
     (lambda (aFriend)
    	; define a "private" greeting
         (define greeting "lovely to see you ")
         ; and a procedure body which captures a continuation during  
         ; a "greeting"
         (display 
              (string-append 
                 greeting
          	(call-with-current-continuation
                    (lambda (aContinuation) 
                       (set! StoredContinuation aContinuation) aFriend))))))
	; HiInContext

(HiInContext "spot")
; lovely to see you spot #t

(define greeting "how very kind of you to come ")
; greeting
(StoredContinuation "spot")
; lovely to see you spot #t

(display (string-append greeting "sally"))
; how very kind of you to come sally #t
(StoredContinuation "sally")
; lovely to see you sally #t)

(define SpellOfEuphoria 
    (lambda (aVictim)
       (call-with-current-continuation
         ; capture a continuation prior to entering the "protected" code 
    	(lambda (aContinuation)
             (string-append 
                "Be ecstatic "
                ; test whether it's "doable" first
                (if (string? aVictim)
                     ; then: ok, go ahead
                     aVictim
                     ; else:  oops ... hop out out this evaluation before (!!)
                     ; any "damage" is done  
                     (aContinuation "victim unsuitable")) ))) ))
; SpellOfEuphoria

(SpellOfEuphoria "cugel")
; "Be ecstactic cugel"
(SpellOfEuphoria 'bruce)
; "victim unsuitable"

(define Ball 
  ; holds a random "number-generator" to decide whether it is 
  ; "dropped",  or in some other state - also stores a continuation 
  ; to escape from  the current play, once it is dropped.
  (lambda (dropProb) 
    (define state #f)  ; "dropped", if dropped, #f otherwise
    (define exitFromPlay #f) 
    ; a continuation returning to the point of the program 
    ; immediately after the game was  started 
    ; (put here by the first player)
    
    (lambda (aMessage . anArgument)
      (cond (; ball dropped ?
                (equal? aMessage 'dropped?)
                (if (eq? state "dropped")
                     #t
                     (if ; return #t in "dropProb" % of all cases
                        (<= (MyRandom 99) (* dropProb 99))
                        (begin (set! state "dropped")
                                  (DisplayLine "oops ...")
                                  (set! state "dropped")
                                  (exitFromPlay #f))
                       #f)) )                          
                       (; pick it up again
                        (equal? aMessage 'pickUp!) (set! state #f))
                        (; stuff continuation to be used at a game's 
                         ; termination into "exitFromPlay" slot 
                        (equal? aMessage 'stuffContinuation!)
                        (set! exitFromPlay (car anArgument)))                     
                      (else ; reject any other requests
                         "Sorry, I don't know how to do this !"))) ))

(define Player
  ; make a player object with 3 attributes: name & partner & ball
  
  (lambda (aName aPartner aBall)
    
        ; and one more for "sequence" control
    (define nextContinuation #f)
    
        ; and a "playBall" method
    (define playBall
      (lambda ()
        ; introduce yourself !
        (DisplayLine "hi "(aPartner 'whoAreYou)) 
        ; now play until the ball is dropped 
        ; (should happen eventually) ! 
        (while #t
          (call-with-current-continuation
            ; capture the state before the ball is gone  and 
            ; "throw" control to your partner 
            (lambda (aContinuation)
              (set! nextContinuation aContinuation) 
              (aPartner 'continue))) 
            ; Reactivation point #1: continue to throw the ball             
           (if (not (aBall 'dropped?))
                (DisplayLine aName 
                                     " throws the ball to "
                                     (aPartner 'whoAreYou)))
            ; if the ball has been dropped we will never get here, 
            ; since the program will "escape" from the ball 
            ; (to the instruction following the start of the game)
          (call-with-current-continuation
             ; capture the state before the "chattering" starts
             ; and "throw" control to your partner
            (lambda (aContinuation)
              (set! nextContinuation aContinuation) 
              (aPartner 'continue))) 
            ; Reactivation point #2: continue to "chatter"
          (DisplayLine "..... " aName ": chitter chatter")) ))
    
    (define dispatch
      ; the "message protocol" of Player 
      (lambda (aMessageSelector . args)
        (cond ((equal? aMessageSelector 'playWith ) 
               (set! aPartner (car args)) 'ok)
              ((equal? aMessageSelector 'whoAreYou) aName)
              ((equal? aMessageSelector 'playBall )
               (call-with-current-continuation
                 (lambda (aContinuation)
                   ; save continuation for exit
                   (aBall 'stuffContinuation! aContinuation) 
                   (playBall))) )
              ((equal? aMessageSelector 'continue ) 
               (if (not nextContinuation)
                   (playBall)
                   (nextContinuation #f)))
              (else  "sorry, I don't know how to do that")) )) 
    
    ; return the dispatch procedure (with environment) 
    ; as the "value" of player
    dispatch))
; Player

(define Mary (Player "Mary" #f))
; mary
(define Jane (Player "Jane" Mary))
; jane
(Mary 'playWith Jane)
; ok

(Mary 'whoAreYou)
; "Mary"
(Mary 'goHome)
; "sorry, I don't know how to do that"

(Mary 'playBall)

