/*
 *  SYMBOL is the structure used for the predicate symbol table.
 */

typedef struct SYMBOL { 
	struct SYMBOL *next;
	struct CLAUSE_CHAIN *clauses;
	int printname;
	int arity;
	int builtin;
} SYMBOL;

/*
 *  PRINTNAME is the structure used for the atom lookup table.
 */

typedef struct PRINTNAME {
	struct PRINTNAME *next;
	int index;
} PRINTNAME;

#define MAXCODE 2048
#define MAXPRED 1024
#define MAXPRINT 16384
#define BUFLEN 2048
#define HASHVAL 31
#define PRINTHASH 31

#define ADD_PRED(A,B)	(A) |= (1<<(B))
#define ADD_SUCC(A,B)	(A) |= (1<<(B))
#define ADD_DET(A,B)	(A) |= (1<<(B))
#define SUCCESSOR(A,B)	((A) & (1<<(B)))

/* flag manipulation macros
 * in each case, A is the variable containing the flag and
 * B is the flag to be manipulated */
#define SET_FLAG(A,B)	(A) |= (1<<(B))
#define IN_FLAG(A,B)	((A) & (1<<(B)))	/* test if set */
#define CLEAR_FLAG(A,B)	(A) &= ~(1<<(B))

#define MkNaryTerm(OutTerm,TagWord,Count,Input, closed) { \
	int i; \
	Malloc_Slots(OutTerm,Count+1); \
	for(i=0;i<Count;i++) \
		OutTerm[i+1] = Input[i]; \
	*OutTerm = TagWord; \
	if (closed && TAG_IS_FUNCTOR(OutTerm)) \
	    MAKE_CLOSED_TERM(OutTerm); \
}

#define MkBinaryTerm(OutTerm,TagWord,Arg1,Arg2, closed) { \
	SLOT *_t; \
	Malloc_Slots(_t,3); \
	*_t = TagWord; \
	_t[1] = Arg1; \
	_t[2] = Arg2; \
	OutTerm = _t; \
	if (closed && TAG_IS_FUNCTOR(OutTerm)) \
	     MAKE_CLOSED_TERM(OutTerm); \
}

#define MkUnaryTerm(OutTerm,TagWord,Arg, closed) { \
	Malloc_Slots(OutTerm,2); \
	*OutTerm = TagWord; \
	OutTerm[1] = Arg; \
	if (closed && TAG_IS_FUNCTOR(OutTerm)) \
	     MAKE_CLOSED_TERM(OutTerm); \
}

#define MkIntg(Ival) ((SLOT) ((Ival << SLOT_TAG_SIZE) | 0x0e))

#define MkAtom(OutTerm,Lval) { \
	SLOT *_t; \
	Malloc_Slots(_t,1); \
	INSERT_CLOSED_TERM(_t,Lval,0); \
	OutTerm = _t; \
}

#define MkFunctor(Atom,Arity) \
	((SLOT) ((Atom << SYM_TAB_SHIFT) | \
			 (Arity << FUNCTOR_SHIFT) | 0x02))

#define MkClosed(Atom,Arity) \
	((SLOT) ((Atom << SYM_TAB_SHIFT) | \
			 (Arity << FUNCTOR_SHIFT) | 0x017))

#define MkVarb(Offset) ((SLOT) ((Offset << SLOT_TAG_SIZE) | TUPLE_INDEX_1))

#define XtrFunc(slot) ((LONG)slot >> SYM_TAB_SHIFT)

#define XtrVarb(slot) ((LONG)*slot >>SLOT_TAG_SIZE)

#define Malloc_Clause(p) \
{\
    OsAlloc(p,sizeof(CLAUSE),CLAUSE);\
    p->clause_det = 0;\
    p->sequential = 0;\
    p->numSeqLitBits = 0;\
    p->clauseNum = 0;\
    p->numClauseBits = 0;\
}

#define Malloc_ClauseVarInfo(p,n)\
{\
    SHORT i;\
    CLAUSE_VAR_TYPE *next;\
    OsAlloc(p,(n)*sizeof(CLAUSE_VAR_TYPE),CLAUSE_VAR_TYPE);\
    for (i=0,next=p; i < n; next->CanImport=next->CanExport=0, next++, i++);\
}
