#include <varargs.h>
#include "typedefs.h"
#include "macros.c"

static SHORT termMem[45][4];

OsAllocTermFunc(size,z) 
int size;
SLOT **z;

{   SLOT kk;

    if (size >= 45) { 
	if ((kk = next_term+size) > maxTerm) { 
	    OsPrint("nextterm is %d, PURE_CODE MARKER IS %dn",
			next_term,PURE_CODE_MARKER);
	    perror("Termspace allocation error,system failed");
	    exit(1);
	}  
	*z = &term_space[next_term];   
	next_term = kk;
	termMem[0][0]++; termMem[0][2] += size;
    } 
    else if (termMem[size][0] == NULL) 
    { 
	kk = next_term + size;
	if (termMem[size][0] == NULL) { 
	    if (kk > maxTerm) { 
		perror("Termspace allocation error,system failed");
		exit(1);
	    }
	    *z = &term_space[next_term];
	    next_term = kk;
	    termMem[size][2]++; termMem[size][3]++;
	}
    }
    else 
    { 
	*z = &term_space[termMem[size][0]]; 
   	termMem[size][0] = (SHORT) *( (SHORT *)*z); 
	termMem[size][2]++; termMem[size][1]--;
    }
    if (DEBUG)
        OsPrintf("Allocating ptr: %x, size(+1): %d \n", *z, size); 
}

OsFreeTerm(ptr,size)
SHORT	size;
SLOT	*ptr;
{   
    if (DEBUG)
        OsPrintf("Freeing term of size: %d ptr: %x \n", size, ptr); 
    if (size >= 45) {
	termMem[0][1]++; 
	}
    else {
    	*((SHORT *)ptr) = termMem[size][0];
    	termMem[size][0] = (SHORT) (ptr - term_space);
    	termMem[size][1]++; 
    }
}
	
