/*
 *		header file for ROPM code generator
 */

#define	MAXINSTR  2500	/* max number of instructions */
#define	MAXSYM	6400	/* max number of symbols */
#define	MAXREG	255	/* max executor pseudo-registers */
#define	ARGSPACES MAXINSTR*5   /* size of instruction argument table */
#define	NULLARG	-1		/* placeholder value for operands */
#define	HEAD	   80		/* 1st invalid arc num - for clause head */
#define	SEQHEAD	   81		/* used for clause head in  seq code  */
#define ADDRCONST  82
#define ADDRATOM   83
#define ADDRLIST   84
#define ADDRSTRUCT 85
#define MUTEXJUMP  86
#define	ARCFREE	   87		/* nextinvalid arc num - used by GenLabel */

#define MOLECSTACKSIZE 6
#define JOINSTACKSIZE  5
#define MAXFORKS       5

#define MOLECSTACK     1        /* encoding for Push and Pop Stack */
#define JOINSTACK      2
#define NODETUPSTACK   3

#define STAT_DET        0x01
#define STAT_NONDET     0x02
#define STAT_ALWAYS_SUC 0x04
#define STAT_MAY_FAIL   0x08
#define STAT_PARENT_DET 0x010

#define	NODEID(c,n,m) (c->NodeIndices[n].nodenum[m])
#define	POSITION(c,n,m) (c->NodeIndices[n].index[m])
#define	LIT(k)		(k+1)
#define	ARC(k)		(k-1)
#define	LOCAL			static
#define	IS_GROUND(c,var) (c->var_info[var].CanImport)
#define	emit(op) Emit(op,"")
#define	PCINDEX(p) ((p)-term_space)
#define	MainEntryPt() (Instr[0].opcode)
#define	MainQuerySize() (Instr[0].arg[0])
#define	MainNumNodes() (Instr[0].arg[1])
#define	MainNumArcs() (Instr[0].arg[2])

#define InsertTopQueryData(c)\
{\
   if (c != NULL)\
   {\
       Instr[0].argCount = 3;\
       Instr[0].arg = argPtr;\
       *argPtr++ = RopmGetQuerySize(c);\
       *argPtr++ = c->num_nodes;\
       *argPtr++ = c->num_arcs;\
   }\
}
/*----------------------------------------------------------------------
 *		generated instruction
 *
 *		variable numbers of arguments are allowed.  arguments all reside
 *		in a large global array, similar to termspace.  the arguments of
 *		an instruction Inst are Inst->arg[0], ..., Inst->arg[argCount-1].
 *--------------------------------------------------------------------*/

typedef struct {
	SHORT opcode;
	SHORT argCount;
	LONG *arg;
	char *argpat;
} Instruction;

/*
 *		procedure symbol table
 */

typedef struct {
	char *name;
	SHORT arity;
} Proc;

/*
extern SLOT *term_space;
extern LONG Loc;
extern Instruction *Instr;
extern Proc procs[];
extern SHORT procNum;
*/
