/*
 * directive.h
 * Header file for directive.c
 *
 * AUTHOR:  David Roch
 *
 * CONTRIBUTORS:
 *	DAR - David Roch
 *	Keith
 *
 * HISTORY:
 *	6/25/88 - Created DAR
 * 	6/28/88 - Added determinism directives
 */

/* Structure of table entries */
typedef struct DIRECTIVE {
  char	*name;
  char	id;
} DIRECTIVE;

/* Values associated with directives */
#define	DIR_ENTRY		1
#define	DIR_CALLPAT		2
#define DIR_DET			3
#define DIR_NOFAIL		4
#define DIR_MUTEX		5
#define DIR_SEQEX		6

static DIRECTIVE directives[] = {
  "entry", 	DIR_ENTRY,
  "callpat",	DIR_CALLPAT,
  "det",	DIR_DET,
  "nofail",	DIR_NOFAIL,
  "mutex",	DIR_MUTEX,
  "seqex",	DIR_SEQEX
  };

#define DIR_COUNT sizeof(directives) / sizeof(DIRECTIVE)

  

