#include "typedefs.h"
#include "macros.c"  
#include "cg.h"  
#include "instruct.h"

/*#define	ID(name) sprintf(s,"%-15s",name); OsPrintf(s)*/
#define	ID(name) printf("%-15s",name);
#define	DUMMYTUPSIZE 100

extern char *TopNames[];
extern Instruction *Instr;
extern LONG Loc;
extern Proc procs[];
char *malloc();

main(argc,argv)
int argc;
char **argv;
{
	LoadFiles(argc,argv);
	Disassemble();
}


Disassemble()
{
	LONG i,n,arg1,arg2,arg3,arg4,arg5, arg6, arg7, arg8, arg9;
	char s[100];
	void PrintTerm();
	SLOT *tuple;

	tuple = (SLOT *)calloc( sizeof(SLOT),DUMMYTUPSIZE );
	for(i=0;i<DUMMYTUPSIZE;i++)
		INSERT_SLOT_TAG((tuple+i),UNBOUND_VAR);
	INSERT_TUPLE_SIZE(tuple,DUMMYTUPSIZE);

	OsPrintf("---- Byte Code Disassembly ----\n");
	OsPrintf("Start address = %d\n", MainEntryPt());
	for( i=1; i<Loc; i++ ) {
	n = Instr[i].opcode;
	arg1 = Instr[i].arg[0];
	arg2 = Instr[i].arg[1];
	arg3 = Instr[i].arg[2];
	arg4 = Instr[i].arg[3];
	arg5 = Instr[i].arg[4];
	arg6 = Instr[i].arg[5];
	arg7 = Instr[i].arg[6];
	arg8 = Instr[i].arg[7];
	arg9 = Instr[i].arg[8];

	sprintf( s, "%-5d        ", i );
	OsPrintf( "%s", s );

	switch( n ) {
	case AllocateBlock:
		ID("AllocateBlock");
		OsPrintf("%d", arg1 );
		break;
	case FireArc:
		ID("FireArc");
		OsPrintf("%d, %d, goalEntry=%d,respEntry=%d,", arg1, arg2, 
			 arg3, arg4);
		PrintTerm( arg5, tuple );
#ifdef PRIORITY
		OsPrintf("(%x), %d, LitDist=%d, SeqLitBits=%d", arg5, arg6, arg7, arg8);
#else
		OsPrintf("(%x), %d", arg5, arg6);
#endif
		break;
	case FreeBlock:
		ID("FreeBlock");
		break;

	case CreateNewQuery:
		ID("CreateNewQuery");
#ifdef PRIORITY
		OsPrintf("num_nodes=%d,num_arcs=%d,query_size=%d,clauseBits=%d,clauseNum=%d", arg1,arg2,arg3,arg4,arg5);
#else
		OsPrintf("num_nodes=%d,num_arcs=%d,query_size=%d", arg1,arg2,arg3);
#endif
		break;

	case Suspend 	:
		ID("Suspend");
		break;

	case Exit 	:
		ID("Exit");
		break;

	case GetFactEnv		:
		ID("GetFactEnv");
		OsPrintf("%x, %d", arg1,arg2);
		break;
	case	GetClauseEnv	:
		ID("GetClauseEnv");
		OsPrintf("%x, %d", arg1,arg2);
		break;
	case	nop:
		ID("Nop");
		break;

	/*=====  unification  =====*/

	case Unify1stVar:
		ID("Unify1stVar");
		OsPrintf("$%d,fail=%d", arg1, arg2);
		break;

	case UnifyVar:
		ID("UnifyVar");
		OsPrintf("$%d,fail=%d", arg1, arg2);
		break;

	case UnifyStrct:
	{
		SHORT func;
		char *s;
		
		ID("UnifyStrct");
		func = GET_FUNCTOR( ((SLOT *)arg1) );
		s = procs[func].name;
		OsPrintf("%s(%x), nextArg=%d, fail=%d, depth=%d", s, 
			 arg1, arg2, arg3, arg4 );
		break;
	}
	case UnifyGround:
		ID("UnifyGround");
		break;
	case UnifyCon:
		ID("UnifyCon");
		OsPrintf("%d, fail=%d", arg1, arg2 );
		break;
	case UnifyAtom:
		ID("UnifyAtom");
		PrintTerm(arg1, tuple);
		OsPrintf(", fail=%d", arg2 );
		break;
	case CloseCVar:
		ID("CloseCVar");
		OsPrintf("$%d", arg1);
		break;
	case TopStack:
		ID("TopStack");
		switch (arg1)
		{
		case 1: OsPrintf("Molecule Stack");
		        break;
		case 2: OsPrintf("Join Stack");
		        break;
		case 3: OsPrintf("Node Tuple Stack");
		        break;
		default:OsPrintf("illegal stack id");
		}
		break;
	case PushStack:
		ID("PushStack");
		switch (arg1)
		{
		case 1: OsPrintf("Molecule Stack");
		        break;
		case 2: OsPrintf("Join Stack");
		        break;
		case 3: OsPrintf("Node Tuple Stack");
		        break;
		default:OsPrintf("illegal stack id");
		}
		break;
	case PopStack:
		ID("PopStack");
		switch (arg1)
		{
		case 1: OsPrintf("Molecule Stack");
		        break;
		case 2: OsPrintf("Join Stack");
		        break;
		case 3: OsPrintf("Node Tuple Stack");
		        break;
		default:OsPrintf("illegal stack id");
		}
		break;
	case SetUpJoin:
		ID("SetUpJoin");
		OsPrintf("%d, %d, %d, %d, %d, %d", arg1, arg2, arg3, arg4, 
			 arg5, arg6);
		break;
	case JoinTuples:
		ID("JoinTuples");
		OsPrintf("%d, %d, %d, %d", arg1, arg2, arg3, arg4);
		break;
	case NextTuple:
		ID("NextTuple");
		OsPrintf("%d, %d, %d", arg1, arg2, arg3);
		break;
	case CopyBackPtr:
		ID("CopyBackPtr");
		OsPrintf("%d, %d, %d, %d", arg1, arg2, arg3, arg4);
		break;
	case MCACheck:
		ID("MCACheck");
		OsPrintf("%d, %d, %d, %d, %d", arg1, arg2, arg3, arg4, arg5);
		break;
	case SetUpNodeTuple:
		ID("SetUpNodeTuple");
		OsPrintf("%d, %d, %d, %d ", arg1, arg2, arg3, arg4);
		break;
	case BeforeUnifPrint:
		ID("BeforeUnifPrint");
		break;
	case AfterUnifPrint:
		ID("AfterUnifPrint");
		break;
	case SendFactResp:
		ID("SendFactResp");
		OsPrintf("%d, %d", arg1, arg2);
		break;
	case SendClauseResp:
		ID("SendClauseResp");
		OsPrintf("%d", arg1);
		break;

	case SendControlMsg:
		ID("SendControlMsg");
		break;

	case CheckResponse:
		ID("CheckResponse");
		OsPrintf("%d, %d", arg1, arg2);
		break;

	case Fail:
		ID("Fail");
		OsPrint("%d", arg1);
		break;

	case Succeed:
		ID("Succeed");
		OsPrintf("%d", arg1);
		break;

	case Newline:
		ID("Newline");
		break;

	case ISVarVar:
		ID("ISVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case ISVarInt:
		ID("ISVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case ISVarAcc:
		ID("ISVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case ISIntAcc:
		ID("ISIntAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case NEVarVar:
		ID("NEVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case NEVarInt:
		ID("NEVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case NEVarAcc:
		ID("NEVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case NEIntAcc:
		ID("NEIntAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case NEAccAcc:
		ID("NEAccAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case LTVarVar:
		ID("LTVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case LTVarInt:
		ID("LTVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case LTVarAcc:
		ID("LTVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case LTIntVar:
		ID("LTIntVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case LTIntAcc:
		ID("LTIntAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case LTAccVar:
		ID("LTAccVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case LTAccInt:
		ID("LTAccInt");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case LTAccAcc:
		ID("LTAccAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case GTVarVar:
		ID("GTVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case GTVarInt:
		ID("GTVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case GTVarAcc:
		ID("GTVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case GTIntVar:
		ID("GTIntVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case GTIntAcc:
		ID("GTIntAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case GTAccVar:
		ID("GTAccVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case GTAccInt:
		ID("GTAccInt");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case GTAccAcc:
		ID("GTAccAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQVarVar:
		ID("EQVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQVarInt:
		ID("EQVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQVarAcc:
		ID("EQVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQIntAcc:
		ID("EQIntAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQAccAcc:
		ID("EQAccAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTVarVar:
		ID("EQLTVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTVarInt:
		ID("EQLTVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTVarAcc:
		ID("EQLTVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTIntVar:
		ID("EQLTIntVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTIntAcc:
		ID("EQLTIntAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTAccVar:
		ID("EQLTAccVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTAccInt:
		ID("EQLTAccInt");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQLTAccAcc:
		ID("EQLTAccAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTVarVar:
		ID("EQGTVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTVarInt:
		ID("EQGTVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTVarAcc:
		ID("EQGTVarAcc");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTIntVar:
		ID("EQGTIntVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTIntAcc:
		ID("EQGTIntAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTAccVar:
		ID("EQGTAccVar");
		OsPrint("%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTAccInt:
		ID("EQGTAccInt");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case EQGTAccAcc:
		ID("EQGTAccAcc");
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case CopyVartoAcc:
		ID("CopyVartoAcc");
		OsPrint("$%d, %d", arg1, arg2);
		break;

	case AddVartoAcc:
		ID("AddVartoAcc");
		OsPrint("$%d, %d", arg1, arg2);
		break;

	case SubVarFromAcc:
		ID("SubVarFromAcc");
		OsPrint("$%d, %d", arg1, arg2);
		break;

	case MultVartoAcc:
		ID("MultVartoAcc");
		OsPrint("$%d, %d", arg1, arg2);
		break;

	case DivAccbyVar:
		ID("DivAccbyVar");
		OsPrint("$%d, %d", arg1, arg2);
		break;

	case ModAccbyVar:
		ID("ModAccbyVar");
		OsPrint("$%d, %d", arg1, arg2);
		break;

	case CopyInttoAcc:
		ID("CopyInttoAcc");
		OsPrint("%d, %d", arg1, arg2);
		break;

	case AddInttoAcc:
		ID("AddInttoAcc");
		OsPrint("%d, %d", arg1, arg2);
		break;

	case SubIntFromAcc:
		ID("SubIntFromAcc");
		OsPrint("%d, %d", arg1, arg2);
		break;

	case MultInttoAcc:
		ID("MultInttoAcc");
		OsPrint("%d, %d", arg1, arg2);
		break;

	case DivAccbyInt:
		ID("DivAccbyInt");
		OsPrint("%d, %d", arg1, arg2);
		break;

	case ModAccbyInt:
		ID("ModAccbyInt");
		OsPrint("%d, %d", arg1, arg2);
		break;

	case UnifyVarTerm:
		ID("UnifyVarTerm");
		OsPrint("$%d,", arg1);
		PrintTerm(arg2, tuple);
		OsPrint("(%d), fail = %d", arg2, arg3);
		break;

	case UnifyVarAtom:
		ID("UnifyVarAtom");
		OsPrint("$%d,", arg1);
		PrintTerm(arg2, tuple);
		OsPrint("(%d), fail = %d", arg2, arg3);
		break;

	case UnifyVarInt:
		ID("UnifyVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;

	case UnifyVarVar:
		ID("UnifyVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case NEqualVarAtom:
		ID("NEqualVarAtom");
		OsPrint("$%d", arg1);
		PrintTerm(arg2, tuple);
		OsPrint("(%d), fail = %d", arg2, arg3);
		break;

	case NEqualVarTerm:
		ID("NEqualVarTerm");
		OsPrint("$%d", arg1);
		PrintTerm(arg2, tuple);
		OsPrint("(%d), fail = %d", arg2, arg3);
		break;

	case NEqualVarInt:
		ID("NEqualVarInt");
		OsPrint("$%d, %d, fail = %d", arg1, arg2, arg3);
		break;
		
	case NEqualVarVar:
		ID("NEqualVarVar");
		OsPrint("$%d, $%d, fail = %d", arg1, arg2, arg3);
		break;

	case Write:
		ID("Write");	
		PrintTerm(arg1, tuple);
		OsPrint("(%d)", arg1);		
		break;

	case Var:
		ID("Var");	
		OsPrint("$%d, fail = %d", arg1, arg2);		
		break;

	case NonVar:
		ID("NonVar");	
		OsPrint("$%d, fail = %d", arg1, arg2);		
		break;

	case Atom:
		ID("Atom");	
		PrintTerm(arg1, tuple);
		OsPrint("(%d), fail = %d", arg1, arg2);		
		break;
		
	case Int:
		ID("Int");	
		OsPrint("%d, fail = %d", arg1, arg2);		
		break;

	case BuiltinArg:
		ID("BuiltinArg");	
		OsPrint("%d, fail = %d", arg1, arg2);		
		break;

	case BuiltinFunc:
		ID("BuiltinFunc");	
		OsPrint("%d, %d, fail = %d", arg1, arg2, arg3);		
		break;

	case BuiltinUniv:
		ID("BuiltinUniv");	
		OsPrint("%d, fail = %d", arg1, arg2);		
		break;

	case PrintVars:
		ID("PrintVars");	
		break;

	case AddTemp:
		ID("AddTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case SubtractTemp:
		ID("SubtractTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case MultiplyTemp:
		ID("MultiplyTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case DivideTemp:
		ID("DivideTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case ModTemp:
		ID("ModTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case DivTemp:
		ID("DivTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case StoreinTemp:
		ID("StoreinTemp");	
		OsPrint("%d, %d", arg1, arg2);
		break;

	case Halt:
		ID("Halt");	
		break;

	case SwitchOnTerm:
		ID("SwitchOnTerm");
		OsPrint("Const = %d, Atom = %d, List = %d, Struct = %d", 
			arg1, arg2, arg3, arg4);
		break;

	case TryMeElse:
		ID("TryMeElse");
		OsPrint("Const = %d, Atom = %d, List = %d, Struct = %d", 
			arg1, arg2, arg3, arg4);
		break;

	case EnterSeqCode:
		ID("EnterSeqCode");
		break;

	case Enter:
		ID("Enter");
		PrintTerm(arg1, tuple);
		OsPrint("(%x), %d, fail = %d", arg1, arg2, arg3);
		break;

	case Cut:
		ID("Cut");
		break;

	    case Call:
		ID("Call");
		PrintTerm(arg1, tuple);
		OsPrint("(%x), %d", arg1, arg2);
		break;

	    case Return:
		ID("Return");
		OsPrintf("%d", arg1);
		break;

	    case SeqFail:
		ID("SeqFail");
		break;

	    case SUnify1stVar:
		ID("SUnify1stVar");
		OsPrint("$%d", arg1);
		break;

	    case SUnifyVar:
		ID("SUnifyVar");
		OsPrint("$%d", arg1);
		break;

	    case SUnifyStrct:
		ID("SUnifyStrct");
		PrintTerm(arg1, tuple);
		OsPrint("(%x), %d, %d", arg1, arg2, arg3);		
		break;

	    case SUnifyAtom:
		ID("SUnifyAtom");
		PrintTerm(arg1, tuple);
		OsPrint("(%x)", arg1);
		break;

	    case SUnifyGround:
		ID("SUnifyGround");
		OsPrint("$%d", arg1);
		break;

	    case SUnifyCon:
		ID("SUnifyCon");
		OsPrint("%d", arg1);
		break;

	default:
		sprintf(s,"unknown %d", n); OsPrintf(s);
	}
	OsPrintf("\n");
	}
}


PgmPrintAtom( procIndex )
int procIndex;
{
	OsPrintf("%s", procs[procIndex].name );
}
